/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.worldgen;

import java.util.List;
import net.levelscraft7.cobblecapsule.worldgen.ModConfiguredFeatures;
import net.levelscraft7.cobblecapsule.worldgen.ModOrePlacement;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> CORE_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("corelite_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_CORE_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("corelite_nether_ore_placed");
    public static final ResourceKey<PlacedFeature> END_CORE_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("corelite_end_ore_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, CORE_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_CORELITE_ORE_KEY), ModOrePlacement.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)16))));
        ModPlacedFeatures.register(context, NETHER_CORE_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_CORELITE_ORE_KEY), ModOrePlacement.rareOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.top())));
        ModPlacedFeatures.register(context, END_CORE_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.END_CORELITE_ORE_KEY), ModOrePlacement.rareOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.top())));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblecapsule", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

