/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.worldgen;

import java.util.List;
import net.levelscraft7.cobblecapsule.block.ModBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_CORELITE_ORE_KEY = ModConfiguredFeatures.registerKey("corelite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_CORELITE_ORE_KEY = ModConfiguredFeatures.registerKey("corelite_nether_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> END_CORELITE_ORE_KEY = ModConfiguredFeatures.registerKey("corelite_end_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        TagMatchTest netherReplaceables = new TagMatchTest(BlockTags.BASE_STONE_NETHER);
        BlockMatchTest endReplaceables = new BlockMatchTest(Blocks.END_STONE);
        List<OreConfiguration.TargetBlockState> overworldCoreliteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.CORELITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.CORELITE_DEEPSLATE_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, OVERWORLD_CORELITE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldCoreliteOres, 8));
        ModConfiguredFeatures.register(context, NETHER_CORELITE_ORE_KEY, Feature.ORE, new OreConfiguration(List.of(OreConfiguration.target((RuleTest)netherReplaceables, (BlockState)((Block)ModBlocks.CORELITE_NETHER_ORE.get()).defaultBlockState())), 8));
        ModConfiguredFeatures.register(context, END_CORELITE_ORE_KEY, Feature.ORE, new OreConfiguration(List.of(OreConfiguration.target((RuleTest)endReplaceables, (BlockState)((Block)ModBlocks.CORELITE_END_ORE.get()).defaultBlockState())), 8));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblecapsule", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

