/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.levelscraft7.cobblecapsule.CobbleCapsule;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;

public class PokemonCapsuleRegistry
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DIRECTORY = "pokemon_capsules";
    public static final PokemonCapsuleRegistry INSTANCE = new PokemonCapsuleRegistry();
    private volatile List<String> pokemon = List.of();

    private PokemonCapsuleRegistry() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList entries = new ArrayList();
        object.forEach((location, json) -> {
            JsonObject obj = GsonHelper.convertToJsonObject((JsonElement)json, (String)"pokemon");
            JsonArray array = GsonHelper.getAsJsonArray((JsonObject)obj, (String)"pokemon");
            array.forEach(element -> entries.add(GsonHelper.convertToString((JsonElement)element, (String)"pokemon")));
        });
        this.pokemon = List.copyOf(entries);
        CobbleCapsule.LOGGER.info("Loaded {} pokemon entries for capsules", (Object)this.pokemon.size());
    }

    public static Optional<String> pickRandomPokemon(RandomSource randomSource) {
        List<String> current = PokemonCapsuleRegistry.INSTANCE.pokemon;
        if (current.isEmpty()) {
            return Optional.empty();
        }
        int index = randomSource.nextInt(current.size());
        return Optional.of(current.get(index));
    }

    public static List<String> getPokemon() {
        return PokemonCapsuleRegistry.INSTANCE.pokemon;
    }
}

