/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.world.level.Level;

public final class LevelUtils {
    private static final Field IS_CLIENT_FIELD;
    private static final Method IS_CLIENT_METHOD;

    private LevelUtils() {
    }

    public static boolean isClient(Level level) {
        if (level == null) {
            return false;
        }
        try {
            if (IS_CLIENT_FIELD != null) {
                return IS_CLIENT_FIELD.getBoolean(level);
            }
            return (Boolean)IS_CLIENT_METHOD.invoke((Object)level, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException("Unable to query client state for level", exception);
        }
    }

    static {
        Field detectedField = null;
        Method detectedMethod = null;
        try {
            detectedField = Level.class.getDeclaredField("isClientSide");
            detectedField.setAccessible(true);
        }
        catch (NoSuchFieldException ignored) {
            try {
                detectedMethod = Level.class.getDeclaredMethod("isClientSide", new Class[0]);
                detectedMethod.setAccessible(true);
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Unable to locate Level#isClientSide accessor", exception);
            }
        }
        IS_CLIENT_FIELD = detectedField;
        IS_CLIENT_METHOD = detectedMethod;
    }
}

