/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.util;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.levelscraft7.cobblecapsule.CobbleCapsule;
import net.levelscraft7.cobblecapsule.item.capsule.LootCapsuleItem;
import net.levelscraft7.cobblecapsule.item.capsule.PokemonCapsuleItem;
import net.levelscraft7.cobblecapsule.util.CapsuleSoundProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public final class CapsuleSoundHelper {
    private static final Optional<CapsuleSoundCue> COMBAT_BASIC = CapsuleSoundHelper.fromVanilla("item.armor.equip_iron", 0.8f, 1.05f);
    private static final Optional<CapsuleSoundCue> COMBAT_RARE = CapsuleSoundHelper.fromVanilla("item.armor.equip_diamond", 0.9f, 1.0f);
    private static final Optional<CapsuleSoundCue> COMBAT_EPIC = CapsuleSoundHelper.fromVanilla("block.anvil.use", 1.0f, 0.95f);
    private static final Optional<CapsuleSoundCue> HEALING_BASIC = CapsuleSoundHelper.fromVanilla("block.amethyst_block.step", 0.8f, 1.2f);
    private static final Optional<CapsuleSoundCue> HEALING_RARE = CapsuleSoundHelper.fromVanilla("block.amethyst_block.hit", 0.85f, 1.15f);
    private static final Optional<CapsuleSoundCue> HEALING_EPIC = CapsuleSoundHelper.fromVanilla("block.amethyst_cluster.break", 0.9f, 0.95f);
    private static final Optional<CapsuleSoundCue> RESOURCE_BASIC = CapsuleSoundHelper.fromVanilla("block.stone.place", 0.8f, 1.0f);
    private static final Optional<CapsuleSoundCue> RESOURCE_RARE = CapsuleSoundHelper.fromVanilla("block.anvil.hit", 0.9f, 1.05f);
    private static final Optional<CapsuleSoundCue> RESOURCE_EPIC = CapsuleSoundHelper.fromVanilla("block.anvil.land", 1.0f, 0.9f);
    private static final Optional<CapsuleSoundCue> POKEMON_BASIC = CapsuleSoundHelper.fromVanilla("entity.experience_orb.pickup", 0.85f, 1.2f);
    private static final Optional<CapsuleSoundCue> POKEMON_RARE = CapsuleSoundHelper.fromVanilla("entity.ender_eye.death", 0.9f, 1.1f);
    private static final Optional<CapsuleSoundCue> POKEMON_EPIC = CapsuleSoundHelper.fromVanilla("entity.evoker.prepare_summon", 1.0f, 0.95f);
    private static final Optional<CapsuleSoundCue> RARE_DROP_CUE = CapsuleSoundHelper.fromVanilla("ui.toast.challenge_complete", 0.7f, 1.1f);
    private static final Set<ResourceLocation> MISSING_LOGGED = Collections.newSetFromMap(new ConcurrentHashMap());

    private CapsuleSoundHelper() {
    }

    public static void playCapsuleSound(ServerLevel level, Player player, CapsuleSoundProfile profile) {
        CapsuleSoundHelper.resolveCue(profile).ifPresent(cue -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.playNotifySound(cue.event(), SoundSource.RECORDS, cue.volume(), cue.pitch());
                level.playSound((Player)serverPlayer, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), cue.event(), SoundSource.RECORDS, cue.volume(), cue.pitch());
            } else {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), cue.event(), SoundSource.RECORDS, cue.volume(), cue.pitch());
            }
        });
    }

    public static void playCapsuleSound(ServerLevel level, BlockPos pos, CapsuleSoundProfile profile) {
        CapsuleSoundHelper.resolveCue(profile).ifPresent(cue -> level.playSound(null, pos, cue.event(), SoundSource.RECORDS, cue.volume(), cue.pitch()));
    }

    public static void playRareDropFanfare(ServerLevel level, Player player) {
        RARE_DROP_CUE.ifPresent(cue -> level.playSound(null, player.getX(), player.getY(), player.getZ(), cue.event(), SoundSource.RECORDS, cue.volume(), cue.pitch()));
    }

    public static Optional<CapsuleSoundProfile> resolveProfile(ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        Item item = stack.getItem();
        if (item instanceof LootCapsuleItem) {
            LootCapsuleItem lootCapsuleItem = (LootCapsuleItem)item;
            return Optional.of(lootCapsuleItem.getSoundProfile());
        }
        item = stack.getItem();
        if (item instanceof PokemonCapsuleItem) {
            PokemonCapsuleItem pokemonCapsuleItem = (PokemonCapsuleItem)item;
            return Optional.of(pokemonCapsuleItem.getSoundProfile());
        }
        return Optional.empty();
    }

    public static boolean shouldPlayRareFanfare(ItemStack stack) {
        return switch (stack.getRarity()) {
            case Rarity.RARE, Rarity.EPIC -> true;
            default -> stack.hasFoil();
        };
    }

    private static Optional<CapsuleSoundCue> resolveCue(CapsuleSoundProfile profile) {
        return switch (profile.family()) {
            default -> throw new MatchException(null, null);
            case CapsuleSoundProfile.Family.COMBAT -> {
                switch (profile.tier()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BASIC: {
                        yield COMBAT_BASIC;
                    }
                    case RARE: {
                        yield COMBAT_RARE;
                    }
                    case EPIC: 
                }
                yield COMBAT_EPIC;
            }
            case CapsuleSoundProfile.Family.HEALING -> {
                switch (profile.tier()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BASIC: {
                        yield HEALING_BASIC;
                    }
                    case RARE: {
                        yield HEALING_RARE;
                    }
                    case EPIC: 
                }
                yield HEALING_EPIC;
            }
            case CapsuleSoundProfile.Family.RESOURCE -> {
                switch (profile.tier()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BASIC: {
                        yield RESOURCE_BASIC;
                    }
                    case RARE: {
                        yield RESOURCE_RARE;
                    }
                    case EPIC: 
                }
                yield RESOURCE_EPIC;
            }
            case CapsuleSoundProfile.Family.POKEMON -> {
                switch (profile.tier()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BASIC: {
                        yield POKEMON_BASIC;
                    }
                    case RARE: {
                        yield POKEMON_RARE;
                    }
                    case EPIC: 
                }
                yield POKEMON_EPIC;
            }
        };
    }

    private static Optional<CapsuleSoundCue> fromVanilla(String path, float volume, float pitch) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)path);
        return BuiltInRegistries.SOUND_EVENT.getOptional(id).map(event -> new CapsuleSoundCue((SoundEvent)event, volume, pitch)).or(() -> {
            if (MISSING_LOGGED.add(id)) {
                CobbleCapsule.LOGGER.warn("Missing vanilla sound event: {}", (Object)id);
            }
            return Optional.empty();
        });
    }

    private record CapsuleSoundCue(SoundEvent event, float volume, float pitch) {
    }
}

