/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.util;

import java.util.EnumMap;
import java.util.Map;
import net.levelscraft7.cobblecapsule.util.CapsuleSoundProfile;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class CapsuleParticleHelper {
    private static final Map<CapsuleSoundProfile.Family, ParticlePalette> FAMILY_PALETTES = new EnumMap<CapsuleSoundProfile.Family, ParticlePalette>(CapsuleSoundProfile.Family.class);
    private static final Map<CapsuleSoundProfile.Tier, BurstShape> TIER_SHAPES = new EnumMap<CapsuleSoundProfile.Tier, BurstShape>(CapsuleSoundProfile.Tier.class);

    private CapsuleParticleHelper() {
    }

    public static void spawnCapsuleBurst(ServerLevel level, ServerPlayer player, CapsuleSoundProfile profile, boolean special) {
        ParticlePalette palette = FAMILY_PALETTES.get((Object)profile.family());
        if (palette == null) {
            return;
        }
        Vec3 origin = player.position().add(0.0, (double)player.getBbHeight() * 0.6, 0.0);
        BurstShape shape = TIER_SHAPES.getOrDefault((Object)profile.tier(), TIER_SHAPES.get((Object)CapsuleSoundProfile.Tier.BASIC));
        int primaryCount = shape.primaryCount();
        int secondaryCount = shape.secondaryCount();
        int accentCount = shape.accentCount();
        double horizontalSpread = shape.horizontalSpread();
        double verticalSpread = shape.verticalSpread();
        double primarySpeed = shape.primarySpeed();
        double secondarySpeed = shape.secondarySpeed();
        double accentSpeed = shape.accentSpeed();
        if (special) {
            primaryCount = (int)Math.round((double)primaryCount * 1.25);
            secondaryCount = (int)Math.round((double)secondaryCount * 1.5);
            accentCount += 6;
            horizontalSpread += 0.1;
            verticalSpread += 0.05;
            primarySpeed += 0.01;
            secondarySpeed += 0.01;
            accentSpeed += 0.01;
        }
        level.sendParticles(palette.primary(), origin.x, origin.y, origin.z, primaryCount, horizontalSpread, verticalSpread, horizontalSpread, primarySpeed);
        if (palette.secondary() != null && secondaryCount > 0) {
            level.sendParticles(palette.secondary(), origin.x, origin.y, origin.z, secondaryCount, horizontalSpread * 0.9, verticalSpread * 0.9, horizontalSpread * 0.9, secondarySpeed);
        }
        if (palette.accent() != null && accentCount > 0) {
            level.sendParticles(palette.accent(), origin.x, origin.y, origin.z, accentCount, horizontalSpread * 0.75, verticalSpread, horizontalSpread * 0.75, accentSpeed);
        }
        if (special) {
            level.sendParticles((ParticleOptions)CapsuleParticleHelper.dust(0.95f, 0.85f, 0.3f, 0.95f), origin.x, origin.y, origin.z, 10, horizontalSpread * 0.8, verticalSpread * 1.1, horizontalSpread * 0.8, 0.04);
            level.sendParticles((ParticleOptions)CapsuleParticleHelper.dust(0.4f, 0.2f, 0.9f, 0.9f), origin.x, origin.y, origin.z, 10, horizontalSpread * 0.8, verticalSpread * 1.1, horizontalSpread * 0.8, 0.04);
        }
    }

    private static DustParticleOptions dust(float red, float green, float blue, float scale) {
        return new DustParticleOptions(new Vector3f(red, green, blue), scale);
    }

    static {
        FAMILY_PALETTES.put(CapsuleSoundProfile.Family.COMBAT, new ParticlePalette((ParticleOptions)ParticleTypes.CRIT, (ParticleOptions)CapsuleParticleHelper.dust(0.85f, 0.2f, 0.15f, 0.9f), (ParticleOptions)ParticleTypes.SMALL_FLAME));
        FAMILY_PALETTES.put(CapsuleSoundProfile.Family.HEALING, new ParticlePalette((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (ParticleOptions)ParticleTypes.HEART, (ParticleOptions)CapsuleParticleHelper.dust(0.8f, 0.35f, 0.75f, 0.85f)));
        FAMILY_PALETTES.put(CapsuleSoundProfile.Family.RESOURCE, new ParticlePalette((ParticleOptions)CapsuleParticleHelper.dust(1.0f, 0.82f, 0.32f, 1.0f), (ParticleOptions)ParticleTypes.END_ROD, (ParticleOptions)ParticleTypes.CRIT));
        FAMILY_PALETTES.put(CapsuleSoundProfile.Family.POKEMON, new ParticlePalette((ParticleOptions)ParticleTypes.ENCHANT, (ParticleOptions)CapsuleParticleHelper.dust(0.35f, 0.15f, 0.85f, 0.9f), (ParticleOptions)ParticleTypes.PORTAL));
        TIER_SHAPES.put(CapsuleSoundProfile.Tier.BASIC, new BurstShape(12, 4, 1, 0.3, 0.18, 0.03, 0.02, 0.01));
        TIER_SHAPES.put(CapsuleSoundProfile.Tier.RARE, new BurstShape(20, 8, 2, 0.45, 0.24, 0.04, 0.025, 0.015));
        TIER_SHAPES.put(CapsuleSoundProfile.Tier.EPIC, new BurstShape(32, 12, 4, 0.62, 0.3, 0.055, 0.03, 0.02));
    }

    private record ParticlePalette(ParticleOptions primary, ParticleOptions secondary, ParticleOptions accent) {
    }

    private record BurstShape(int primaryCount, int secondaryCount, int accentCount, double horizontalSpread, double verticalSpread, double primarySpeed, double secondarySpeed, double accentSpeed) {
    }
}

