/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.util;

import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;

public final class CapsuleCooldowns {
    public static final long COOLDOWN_TICKS = 60L;
    private static final long MAX_REASONABLE_REMAINING = 1200L;
    private static final String ROOT_KEY = "CapsuleCooldowns";

    private CapsuleCooldowns() {
    }

    public static long getExpiresAt(ServerPlayer player, String key) {
        CompoundTag persistentData = player.getPersistentData();
        if (!persistentData.contains(ROOT_KEY, 10)) {
            return 0L;
        }
        CompoundTag cooldownTag = persistentData.getCompound(ROOT_KEY);
        return cooldownTag.getLong(key);
    }

    public static void setExpiresAt(ServerPlayer player, String key, long expiresAt) {
        CompoundTag persistentData = player.getPersistentData();
        CompoundTag cooldownTag = persistentData.getCompound(ROOT_KEY);
        cooldownTag.putLong(key, expiresAt);
        persistentData.put(ROOT_KEY, (Tag)cooldownTag);
    }

    public static void clearCooldown(ServerPlayer player, String key) {
        CompoundTag persistentData = player.getPersistentData();
        if (!persistentData.contains(ROOT_KEY, 10)) {
            return;
        }
        CompoundTag cooldownTag = persistentData.getCompound(ROOT_KEY);
        cooldownTag.remove(key);
        persistentData.put(ROOT_KEY, (Tag)cooldownTag);
    }

    public static boolean handleCooldown(ServerPlayer player, String key, long currentTick) {
        long expiresAt = CapsuleCooldowns.getExpiresAt(player, key);
        if (expiresAt <= 0L) {
            return false;
        }
        long remainingTicks = expiresAt - currentTick;
        if (remainingTicks <= 0L) {
            CapsuleCooldowns.clearCooldown(player, key);
            return false;
        }
        if (remainingTicks > 1200L) {
            CapsuleCooldowns.clearCooldown(player, key);
            return false;
        }
        CapsuleCooldowns.sendCooldownMessage(player, remainingTicks);
        return true;
    }

    public static void sendCooldownMessage(ServerPlayer player, long remainingTicks) {
        double seconds = (double)remainingTicks / 20.0;
        String formatted = String.format(Locale.ROOT, "%.1f", seconds);
        MutableComponent message = Component.translatable((String)"message.%s.cooldown".formatted("cobblecapsule"), (Object[])new Object[]{formatted});
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)message));
    }
}

