/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.levelscraft7.cobblecapsule.block.custom.CoreTableBlock;
import net.levelscraft7.cobblecapsule.recipe.CoreTableRecipeInput;
import net.levelscraft7.cobblecapsule.recipe.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CoreTableRecipe
implements Recipe<CoreTableRecipeInput> {
    private final Ingredient activatorIngredient;
    private final CoreRequirement coreRequirement;
    private final Ingredient capsuleIngredient;
    private final ItemStack result;
    private final int resultWeight;
    private final List<ResultOption> additionalResults;
    private final int totalWeight;
    private final NonNullList<Ingredient> ingredients;
    private final int craftingTime;

    public CoreTableRecipe(Ingredient activatorIngredient, CoreRequirement coreRequirement, Ingredient capsuleIngredient, ItemStack result, int craftingTime) {
        this(activatorIngredient, coreRequirement, capsuleIngredient, result, craftingTime, 1, List.of());
    }

    public CoreTableRecipe(Ingredient activatorIngredient, CoreRequirement coreRequirement, Ingredient capsuleIngredient, ItemStack result, int craftingTime, int resultWeight, List<ResultOption> additionalResults) {
        this.activatorIngredient = activatorIngredient;
        this.coreRequirement = coreRequirement;
        this.capsuleIngredient = capsuleIngredient;
        this.result = result.copy();
        if (resultWeight <= 0) {
            throw new IllegalArgumentException("Result weight must be positive");
        }
        this.resultWeight = resultWeight;
        this.additionalResults = List.copyOf(additionalResults);
        int accumulatedWeight = resultWeight;
        for (ResultOption option : this.additionalResults) {
            accumulatedWeight += option.weight();
        }
        this.totalWeight = accumulatedWeight;
        this.ingredients = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{activatorIngredient, coreRequirement.ingredient(), capsuleIngredient});
        this.craftingTime = craftingTime;
    }

    public boolean matches(CoreTableRecipeInput input, Level level) {
        ItemStack activator = input.getItem(0);
        ItemStack core = input.getItem(1);
        ItemStack ingredient = input.getItem(2);
        if (!this.activatorIngredient.test(activator)) {
            return false;
        }
        if (!this.capsuleIngredient.test(ingredient)) {
            return false;
        }
        if (!this.coreRequirement.ingredient().test(core)) {
            return false;
        }
        int coreLevel = CoreTableBlock.getCoreLevel(core);
        return coreLevel == this.coreRequirement.level();
    }

    public ItemStack assemble(CoreTableRecipeInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.CORE_TABLE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.CORE_TABLE_TYPE.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public Ingredient getActivatorIngredient() {
        return this.activatorIngredient;
    }

    public CoreRequirement getCoreRequirement() {
        return this.coreRequirement;
    }

    public Ingredient getCoreIngredient() {
        return this.coreRequirement.ingredient();
    }

    public int getRequiredCoreLevel() {
        return this.coreRequirement.level();
    }

    public Ingredient getCapsuleIngredient() {
        return this.capsuleIngredient;
    }

    public ItemStack getResultStack() {
        return this.result;
    }

    public int craftingTime() {
        return this.craftingTime;
    }

    public int getResultWeight() {
        return this.resultWeight;
    }

    public List<ResultOption> getAdditionalResults() {
        return this.additionalResults;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public boolean hasAdditionalResults() {
        return !this.additionalResults.isEmpty();
    }

    public List<ItemStack> getDisplayResults() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(1 + this.additionalResults.size());
        stacks.add(this.result.copy());
        for (ResultOption option : this.additionalResults) {
            stacks.add(option.stack().copy());
        }
        return stacks;
    }

    public Optional<ItemStack> findMatchingResult(ItemStack stack) {
        if (ItemStack.isSameItemSameComponents((ItemStack)this.result, (ItemStack)stack)) {
            return Optional.of(this.result.copy());
        }
        for (ResultOption option : this.additionalResults) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)option.stack(), (ItemStack)stack)) continue;
            return Optional.of(option.stack().copy());
        }
        return Optional.empty();
    }

    public ItemStack rollOutput(RandomSource random) {
        if (!this.hasAdditionalResults()) {
            return this.result.copy();
        }
        int roll = random.nextInt(this.totalWeight);
        if (roll < this.resultWeight) {
            return this.result.copy();
        }
        int accumulated = this.resultWeight;
        for (ResultOption option : this.additionalResults) {
            if (roll >= (accumulated += option.weight())) continue;
            return option.stack().copy();
        }
        return this.result.copy();
    }

    public List<ResultChance> getResultChances() {
        if (this.totalWeight <= 0) {
            return List.of();
        }
        ArrayList<ResultChance> chances = new ArrayList<ResultChance>(1 + this.additionalResults.size());
        chances.add(new ResultChance(this.result.copy(), (double)this.resultWeight * 100.0 / (double)this.totalWeight));
        for (ResultOption option : this.additionalResults) {
            chances.add(new ResultChance(option.stack().copy(), (double)option.weight() * 100.0 / (double)this.totalWeight));
        }
        return chances;
    }

    public record CoreRequirement(Ingredient ingredient, int level) {
        private static final MapCodec<CoreRequirement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(CoreRequirement::ingredient), (App)Codec.INT.fieldOf("level").forGetter(CoreRequirement::level)).apply((Applicative)instance, CoreRequirement::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, CoreRequirement> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CoreRequirement::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, CoreRequirement::level, CoreRequirement::new);
    }

    public record ResultOption(ItemStack stack, int weight) {
        private static final Codec<ResultOption> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(ResultOption::stack), (App)Codec.INT.fieldOf("weight").forGetter(ResultOption::weight)).apply((Applicative)instance, ResultOption::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ResultOption> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ResultOption::stack, (StreamCodec)ByteBufCodecs.VAR_INT, ResultOption::weight, ResultOption::new);

        public ResultOption(ItemStack stack, int weight) {
            if (stack.isEmpty()) {
                throw new IllegalArgumentException("Result option stack cannot be empty");
            }
            if (weight <= 0) {
                throw new IllegalArgumentException("Result option weight must be positive");
            }
            this.stack = stack = stack.copy();
            this.weight = weight;
        }
    }

    public record ResultChance(ItemStack stack, double percentage) {
    }

    public static class Serializer
    implements RecipeSerializer<CoreTableRecipe> {
        private static final MapCodec<CoreTableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("activator").forGetter(CoreTableRecipe::getActivatorIngredient), (App)CoreRequirement.CODEC.fieldOf("core").forGetter(CoreTableRecipe::getCoreRequirement), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(CoreTableRecipe::getCapsuleIngredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(CoreTableRecipe::getResultStack), (App)Codec.INT.optionalFieldOf("crafting_time", (Object)72).forGetter(CoreTableRecipe::craftingTime), (App)Codec.INT.optionalFieldOf("result_weight", (Object)1).forGetter(CoreTableRecipe::getResultWeight), (App)ResultOption.CODEC.listOf().optionalFieldOf("additional_results", List.of()).forGetter(CoreTableRecipe::getAdditionalResults)).apply((Applicative)instance, CoreTableRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, List<ResultOption>> RESULT_OPTIONS_STREAM_CODEC = StreamCodec.of((buffer, value) -> {
            buffer.writeVarInt(value.size());
            for (ResultOption option : value) {
                ResultOption.STREAM_CODEC.encode(buffer, (Object)option);
            }
        }, buffer -> {
            int size = buffer.readVarInt();
            ArrayList<ResultOption> options = new ArrayList<ResultOption>(size);
            for (int i = 0; i < size; ++i) {
                options.add((ResultOption)ResultOption.STREAM_CODEC.decode(buffer));
            }
            return options;
        });
        private static final StreamCodec<RegistryFriendlyByteBuf, CoreTableRecipe> STREAM_CODEC = StreamCodec.of((buffer, recipe) -> {
            Ingredient.CONTENTS_STREAM_CODEC.encode(buffer, (Object)recipe.getActivatorIngredient());
            CoreRequirement.STREAM_CODEC.encode(buffer, (Object)recipe.getCoreRequirement());
            Ingredient.CONTENTS_STREAM_CODEC.encode(buffer, (Object)recipe.getCapsuleIngredient());
            ItemStack.STREAM_CODEC.encode(buffer, (Object)recipe.getResultStack());
            ByteBufCodecs.VAR_INT.encode(buffer, (Object)recipe.craftingTime());
            ByteBufCodecs.VAR_INT.encode(buffer, (Object)recipe.getResultWeight());
            RESULT_OPTIONS_STREAM_CODEC.encode(buffer, recipe.getAdditionalResults());
        }, buffer -> new CoreTableRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buffer), (CoreRequirement)CoreRequirement.STREAM_CODEC.decode(buffer), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buffer), (ItemStack)ItemStack.STREAM_CODEC.decode(buffer), (Integer)ByteBufCodecs.VAR_INT.decode(buffer), (Integer)ByteBufCodecs.VAR_INT.decode(buffer), (List)RESULT_OPTIONS_STREAM_CODEC.decode(buffer)));

        public MapCodec<CoreTableRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CoreTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

