/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.menu;

import java.util.Objects;
import net.levelscraft7.cobblecapsule.block.ModBlocks;
import net.levelscraft7.cobblecapsule.block.entity.CoreTableBlockEntity;
import net.levelscraft7.cobblecapsule.menu.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CoreTableMenu
extends AbstractContainerMenu {
    private static final int BLOCK_ENTITY_SLOT_COUNT = 4;
    private static final int PROGRESS_BAR_WIDTH = 21;
    private final CoreTableBlockEntity blockEntity;
    private final ContainerLevelAccess access;
    private final ContainerData data;

    public CoreTableMenu(int containerId, Inventory inventory, RegistryFriendlyByteBuf buffer) {
        this(containerId, inventory, inventory.player.level(), buffer.readBlockPos());
    }

    public CoreTableMenu(int containerId, Inventory inventory, CoreTableBlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.CORE_TABLE_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.create((Level)Objects.requireNonNull(blockEntity.getLevel()), (BlockPos)blockEntity.getBlockPos());
        this.data = data;
        this.addDataSlots(data);
        this.addBlockEntitySlots();
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
    }

    private CoreTableMenu(int containerId, Inventory inventory, Level level, BlockPos pos) {
        this(containerId, inventory, CoreTableMenu.getBlockEntity(level, pos));
    }

    private static CoreTableBlockEntity getBlockEntity(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CoreTableBlockEntity) {
            CoreTableBlockEntity coreTable = (CoreTableBlockEntity)blockEntity;
            return coreTable;
        }
        throw new IllegalStateException("No Core Table block entity found at " + String.valueOf(pos));
    }

    private void addBlockEntitySlots() {
        ItemStackHandler handler = this.blockEntity.getItemHandler();
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 0, 33, 37));
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)handler, 1, 51, 37){

            public int getMaxStackSize() {
                return 16;
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 2, 69, 37){

            public boolean mayPlace(@NotNull ItemStack stack) {
                if (CoreTableMenu.this.blockEntity.hasActiveRecipe()) {
                    return false;
                }
                return super.mayPlace(stack);
            }

            public boolean mayPickup(@NotNull Player player) {
                if (CoreTableMenu.this.blockEntity.hasActiveRecipe()) {
                    return false;
                }
                return super.mayPickup(player);
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 3, 123, 37){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return false;
            }

            public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
                super.onTake(player, stack);
                CoreTableMenu.this.blockEntity.onResultTaken(player, stack);
            }
        });
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9 + 9;
                int x = 8 + column * 18;
                int y = 84 + row * 18;
                this.addSlot(new Slot((Container)inventory, index, x, y));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int slot = 0; slot < 9; ++slot) {
            this.addSlot(new Slot((Container)inventory, slot, 8 + slot * 18, 142));
        }
    }

    public CoreTableMenu(int containerId, Inventory inventory, CoreTableBlockEntity blockEntity) {
        this(containerId, inventory, blockEntity, blockEntity.getDataAccess());
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        if (index < 0 || index >= this.slots.size()) {
            return ItemStack.EMPTY;
        }
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = slot.getItem();
        ItemStack stack = slotStack.copy();
        if (index < 4 ? !this.moveItemStackTo(slotStack, 4, this.slots.size(), true) : !this.moveItemStackTo(slotStack, 0, 4, false)) {
            return ItemStack.EMPTY;
        }
        if (slotStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        slot.onTake(player, slotStack);
        return stack;
    }

    public boolean stillValid(@NotNull Player player) {
        return CoreTableMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.CORE_TABLE.get()));
    }

    public boolean isCrafting() {
        return this.getProgress() > 0;
    }

    public int getProgress() {
        return this.data.get(0);
    }

    public int getMaxProgress() {
        return this.data.get(1);
    }

    public int getScaledProgress() {
        int progress = this.getProgress();
        int maxProgress = this.getMaxProgress();
        if (progress == 0 || maxProgress == 0) {
            return 0;
        }
        int width = progress * 21 / maxProgress;
        return Math.min(width, 21);
    }
}

