/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.item.capsule;

import java.util.Optional;
import net.levelscraft7.cobblecapsule.Config;
import net.levelscraft7.cobblecapsule.item.capsule.AbstractCapsuleItem;
import net.levelscraft7.cobblecapsule.util.CapsuleCooldowns;
import net.levelscraft7.cobblecapsule.util.CapsuleParticleHelper;
import net.levelscraft7.cobblecapsule.util.CapsuleSoundHelper;
import net.levelscraft7.cobblecapsule.util.CapsuleSoundProfile;
import net.levelscraft7.cobblecapsule.util.PokemonCapsuleRegistry;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PokemonCapsuleItem
extends AbstractCapsuleItem {
    private final boolean shiny;
    private final CapsuleSoundProfile soundProfile;

    public PokemonCapsuleItem(Item.Properties properties, boolean shiny, CapsuleSoundProfile soundProfile) {
        super(properties, shiny ? "pokemon_shiny" : "pokemon_regular");
        this.shiny = shiny;
        this.soundProfile = soundProfile;
    }

    public CapsuleSoundProfile getSoundProfile() {
        return this.soundProfile;
    }

    @Override
    protected boolean activate(ServerLevel level, ServerPlayer player, ItemStack consumedStack) {
        Optional<String> pokemon = PokemonCapsuleRegistry.pickRandomPokemon(level.getRandom());
        if (pokemon.isEmpty()) {
            CapsuleCooldowns.clearCooldown(player, this.shiny ? "pokemon_shiny" : "pokemon_regular");
            player.displayClientMessage((Component)Component.translatable((String)"message.%s.pokemon_capsule_empty".formatted("cobblecapsule")), true);
            return false;
        }
        int minLevel = Config.getPokemonCapsuleMinLevel(this.shiny);
        int maxLevel = Config.getPokemonCapsuleMaxLevel(this.shiny);
        int levelValue = Mth.nextInt((RandomSource)level.getRandom(), (int)minLevel, (int)maxLevel);
        String command = "/pokespawn \"" + pokemon.get() + "\" level=" + levelValue + " shiny=" + (this.shiny ? "yes" : "no");
        CommandSourceStack source = new CommandSourceStack(CommandSource.NULL, player.position(), player.getRotationVector(), level, 4, player.getName().getString(), player.getDisplayName(), level.getServer(), null).withSuppressedOutput();
        level.getServer().getCommands().performPrefixedCommand(source, command);
        CapsuleSoundHelper.playCapsuleSound(level, (Player)player, this.soundProfile);
        CapsuleParticleHelper.spawnCapsuleBurst(level, player, this.soundProfile, this.shiny);
        return true;
    }
}

