/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.item.capsule;

import java.util.ArrayList;
import java.util.HashSet;
import net.levelscraft7.cobblecapsule.item.capsule.AbstractCapsuleItem;
import net.levelscraft7.cobblecapsule.util.CapsuleLootManager;
import net.levelscraft7.cobblecapsule.util.CapsuleParticleHelper;
import net.levelscraft7.cobblecapsule.util.CapsuleSoundHelper;
import net.levelscraft7.cobblecapsule.util.CapsuleSoundProfile;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LootCapsuleItem
extends AbstractCapsuleItem {
    private final ResourceLocation lootTable;
    private final boolean allowDuplicates;
    private final CapsuleSoundProfile soundProfile;

    public LootCapsuleItem(Item.Properties properties, ResourceLocation lootTable, boolean allowDuplicates, CapsuleSoundProfile soundProfile) {
        super(properties, lootTable.toString());
        this.lootTable = lootTable;
        this.allowDuplicates = allowDuplicates;
        this.soundProfile = soundProfile;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public boolean allowsDuplicates() {
        return this.allowDuplicates;
    }

    public CapsuleSoundProfile getSoundProfile() {
        return this.soundProfile;
    }

    @Override
    protected boolean activate(ServerLevel level, ServerPlayer player, ItemStack consumedStack) {
        ArrayList<ItemStack> generatedLoot = new ArrayList<ItemStack>(CapsuleLootManager.generateLoot(level, this.lootTable));
        if (!this.allowDuplicates) {
            HashSet seen = new HashSet();
            generatedLoot.removeIf(stack -> {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                if (seen.contains(id)) {
                    return true;
                }
                seen.add(id);
                return false;
            });
        }
        CapsuleSoundHelper.playCapsuleSound(level, (Player)player, this.soundProfile);
        CapsuleParticleHelper.spawnCapsuleBurst(level, player, this.soundProfile, false);
        boolean rareLoot = generatedLoot.stream().anyMatch(stack -> !stack.isEmpty() && CapsuleSoundHelper.shouldPlayRareFanfare(stack));
        if (rareLoot) {
            CapsuleSoundHelper.playRareDropFanfare(level, (Player)player);
        }
        for (ItemStack stack2 : generatedLoot) {
            if (stack2.isEmpty() || player.addItem(stack2)) continue;
            player.drop(stack2, false);
        }
        return true;
    }
}

