/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.item.capsule;

import net.levelscraft7.cobblecapsule.Config;
import net.levelscraft7.cobblecapsule.util.CapsuleCooldowns;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractCapsuleItem
extends Item {
    private final String cooldownKey;

    protected AbstractCapsuleItem(Item.Properties properties, String cooldownKey) {
        super(properties);
        this.cooldownKey = cooldownKey;
    }

    public int getMaxStackSize(ItemStack stack) {
        return Config.getCapsuleStackLimit();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.consume((Object)stack);
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        long currentTick = serverPlayer.serverLevel().getGameTime();
        if (CapsuleCooldowns.handleCooldown(serverPlayer, this.cooldownKey, currentTick)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!this.activate(serverPlayer.serverLevel(), serverPlayer, stack.copyWithCount(1))) {
            return InteractionResultHolder.fail((Object)stack);
        }
        CapsuleCooldowns.setExpiresAt(serverPlayer, this.cooldownKey, currentTick + 60L);
        serverPlayer.getCooldowns().addCooldown((Item)this, 60);
        serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!serverPlayer.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    protected abstract boolean activate(ServerLevel var1, ServerPlayer var2, ItemStack var3);
}

