/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.levelscraft7.cobblecapsule.block.ModBlocks;
import net.levelscraft7.cobblecapsule.item.ModItems;
import net.levelscraft7.cobblecapsule.recipe.CoreTableRecipe;
import net.levelscraft7.cobblecapsule.util.ModTags;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final String COBBLEMON_MOD = "cobblemon";
    private static final AdvancementHolder ROOT_RECIPE_ADVANCEMENT = Advancement.Builder.recipeAdvancement().build(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        Item cobblemonCoinPouch = ModRecipeProvider.getExternalItem(COBBLEMON_MOD, "relic_coin_pouch");
        Item cobblemonRevive = ModRecipeProvider.getExternalItem(COBBLEMON_MOD, "revive");
        Item cobblemonMaxRevive = ModRecipeProvider.getExternalItem(COBBLEMON_MOD, "max_revive");
        Item cobblemonUltraBall = ModRecipeProvider.getExternalItem(COBBLEMON_MOD, "ultra_ball");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CORELINK_ACTIVATOR.get())).pattern("  D").pattern(" I ").pattern("S  ").define(Character.valueOf('D'), (ItemLike)Items.DIAMOND).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_diamond", ModRecipeProvider.has((ItemLike)Items.DIAMOND)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CORELITE_CRYSTAL.get())).pattern("SSS").pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)ModItems.CORELITE_SHARD.get()).unlockedBy("has_corelite_shard", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CORELITE_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CORELITE_BLOCK.get())).pattern("III").pattern("III").pattern("III").define(Character.valueOf('I'), (ItemLike)ModItems.CORELITE_INGOT.get()).unlockedBy("has_corelite_ingot", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CORELITE_INGOT.get()))).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CORELITE_INGOT.get()), (int)9).requires((ItemLike)ModBlocks.CORELITE_BLOCK.get()).unlockedBy("has_corelite_block", ModRecipeProvider.has((ItemLike)((ItemLike)ModBlocks.CORELITE_BLOCK.get()))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"cobblecapsule", (String)"corelite_ingot_from_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CORELITE_INGOT.get())).requires((ItemLike)ModItems.CORELITE_CRYSTAL.get()).requires((ItemLike)Items.IRON_INGOT).unlockedBy("has_corelite_crystal", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CORELITE_CRYSTAL.get()))).unlockedBy("has_iron_ingot", ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"cobblecapsule", (String)"corelite_ingot_from_crystal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.INFUSED_COAL.get())).pattern("SSS").pattern("SCS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)ModItems.CORELITE_SHARD.get()).define(Character.valueOf('C'), (ItemLike)Items.COAL).unlockedBy("has_corelite_shard", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CORELITE_SHARD.get()))).unlockedBy("has_coal", ModRecipeProvider.has((ItemLike)Items.COAL)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.CORE_TABLE.get())).pattern("III").pattern("CTC").pattern("III").define(Character.valueOf('I'), (ItemLike)ModItems.CORELITE_INGOT.get()).define(Character.valueOf('C'), (ItemLike)ModItems.CORELITE_CRYSTAL.get()).define(Character.valueOf('T'), (ItemLike)Items.CRAFTING_TABLE).unlockedBy("has_corelite_ingot", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CORELITE_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.DISPLAY_CASE.get()), (int)2).pattern("GGG").pattern("GIG").pattern("PPP").define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('I'), (ItemLike)ModItems.CORELITE_INGOT.get()).define(Character.valueOf('P'), (ItemLike)Items.SPRUCE_PLANKS).unlockedBy("has_corelite_ingot", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CORELITE_INGOT.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CAPSULE_CORE_BASIC.get())).pattern(" S ").pattern("SIS").pattern(" S ").define(Character.valueOf('S'), (ItemLike)ModItems.CORELITE_SHARD.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_corelite_shard", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CORELITE_SHARD.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CAPSULE_CORE_RARE.get())).pattern(" C ").pattern("GBG").pattern(" C ").define(Character.valueOf('C'), (ItemLike)ModItems.CORELITE_CRYSTAL.get()).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('B'), (ItemLike)ModItems.CAPSULE_CORE_BASIC.get()).unlockedBy("has_capsule_core_basic", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CAPSULE_CORE_BASIC.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CAPSULE_CORE_EPIC.get())).pattern("ADA").pattern("RBR").pattern("ADA").define(Character.valueOf('A'), (ItemLike)ModItems.CORELITE_INGOT.get()).define(Character.valueOf('D'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('R'), (ItemLike)ModItems.CAPSULE_CORE_RARE.get()).define(Character.valueOf('B'), (ItemLike)Items.DIAMOND).unlockedBy("has_capsule_core_rare", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CAPSULE_CORE_RARE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HEALING_CORE.get())).pattern("   ").pattern("HBH").pattern("GGG").define(Character.valueOf('H'), ModTags.Items.COBBLEMON_HEALING_ITEMS).define(Character.valueOf('G'), (ItemLike)Items.GLISTERING_MELON_SLICE).define(Character.valueOf('B'), (ItemLike)ModItems.CAPSULE_CORE_BASIC.get()).unlockedBy("has_capsule_core_basic", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CAPSULE_CORE_BASIC.get()))).unlockedBy("has_revive", ModRecipeProvider.has((ItemLike)cobblemonRevive)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.COMBAT_CORE.get())).pattern(" X ").pattern("SBS").pattern(" F ").define(Character.valueOf('F'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('S'), (ItemLike)Items.IRON_SWORD).define(Character.valueOf('X'), ModTags.Items.COBBLEMON_BATTLE_ITEMS).define(Character.valueOf('B'), (ItemLike)ModItems.CAPSULE_CORE_RARE.get()).unlockedBy("has_capsule_core_rare", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CAPSULE_CORE_RARE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.RESOURCE_CORE.get())).pattern(" A ").pattern("PBP").pattern(" E ").define(Character.valueOf('E'), ModTags.Items.BEACON_PAYMENT_ITEMS).define(Character.valueOf('A'), (ItemLike)cobblemonCoinPouch).define(Character.valueOf('P'), (ItemLike)Items.IRON_PICKAXE).define(Character.valueOf('B'), (ItemLike)ModItems.CAPSULE_CORE_RARE.get()).unlockedBy("has_capsule_core_rare", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CAPSULE_CORE_RARE.get()))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.POKEMON_CORE.get())).pattern(" F ").pattern("UBU").pattern("ERE").define(Character.valueOf('R'), (ItemLike)cobblemonMaxRevive).define(Character.valueOf('E'), (ItemLike)Items.DRAGON_BREATH).define(Character.valueOf('U'), (ItemLike)cobblemonUltraBall).define(Character.valueOf('B'), (ItemLike)ModItems.CAPSULE_CORE_EPIC.get()).define(Character.valueOf('F'), (ItemLike)Items.ENDER_EYE).unlockedBy("has_capsule_core_epic", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CAPSULE_CORE_EPIC.get()))).unlockedBy("has_revive", ModRecipeProvider.has((ItemLike)cobblemonRevive)).save(recipeOutput);
        this.addCoreTableCapsuleRecipes(recipeOutput);
    }

    private void addCoreTableCapsuleRecipes(RecipeOutput recipeOutput) {
        this.coreTableCapsuleRecipe(recipeOutput, "healing_capsule_basic", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_BASIC, 1, (Supplier<? extends ItemLike>)ModItems.HEALING_CORE, new ItemStack((ItemLike)ModItems.HEALING_CAPSULE_BASIC.get()), 160);
        this.coreTableCapsuleRecipe(recipeOutput, "healing_capsule_rare", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_RARE, 2, (Supplier<? extends ItemLike>)ModItems.HEALING_CORE, new ItemStack((ItemLike)ModItems.HEALING_CAPSULE_RARE.get()), 220);
        this.coreTableCapsuleRecipe(recipeOutput, "healing_capsule_epic", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_EPIC, 3, (Supplier<? extends ItemLike>)ModItems.HEALING_CORE, new ItemStack((ItemLike)ModItems.HEALING_CAPSULE_EPIC.get()), 280);
        this.coreTableCapsuleRecipe(recipeOutput, "combat_capsule_basic", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_BASIC, 1, (Supplier<? extends ItemLike>)ModItems.COMBAT_CORE, new ItemStack((ItemLike)ModItems.COMBAT_CAPSULE_BASIC.get()), 160);
        this.coreTableCapsuleRecipe(recipeOutput, "combat_capsule_rare", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_RARE, 2, (Supplier<? extends ItemLike>)ModItems.COMBAT_CORE, new ItemStack((ItemLike)ModItems.COMBAT_CAPSULE_RARE.get()), 220);
        this.coreTableCapsuleRecipe(recipeOutput, "combat_capsule_epic", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_EPIC, 3, (Supplier<? extends ItemLike>)ModItems.COMBAT_CORE, new ItemStack((ItemLike)ModItems.COMBAT_CAPSULE_EPIC.get()), 280);
        this.coreTableCapsuleRecipe(recipeOutput, "resource_capsule_basic", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_BASIC, 1, (Supplier<? extends ItemLike>)ModItems.RESOURCE_CORE, new ItemStack((ItemLike)ModItems.RESOURCE_CAPSULE_BASIC.get()), 160);
        this.coreTableCapsuleRecipe(recipeOutput, "resource_capsule_rare", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_RARE, 2, (Supplier<? extends ItemLike>)ModItems.RESOURCE_CORE, new ItemStack((ItemLike)ModItems.RESOURCE_CAPSULE_RARE.get()), 220);
        this.coreTableCapsuleRecipe(recipeOutput, "resource_capsule_epic", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_EPIC, 3, (Supplier<? extends ItemLike>)ModItems.RESOURCE_CORE, new ItemStack((ItemLike)ModItems.RESOURCE_CAPSULE_EPIC.get()), 280);
        this.coreTableCapsuleRecipe(recipeOutput, "pokemon_capsule", (Supplier<? extends ItemLike>)ModItems.CAPSULE_CORE_EPIC, 3, (Supplier<? extends ItemLike>)ModItems.POKEMON_CORE, new ItemStack((ItemLike)ModItems.POKEMON_CAPSULE.get()), 280, 6, List.of(new CoreTableRecipe.ResultOption(new ItemStack((ItemLike)ModItems.POKEMON_CAPSULE_SHINY.get()), 1)));
    }

    private void coreTableCapsuleRecipe(RecipeOutput recipeOutput, String name, Supplier<? extends ItemLike> capsuleCore, int coreLevel, Supplier<? extends ItemLike> capsuleIngredient, ItemStack result, int craftingTime) {
        this.coreTableCapsuleRecipe(recipeOutput, name, capsuleCore, coreLevel, capsuleIngredient, result, craftingTime, 1, List.of());
    }

    private void coreTableCapsuleRecipe(RecipeOutput recipeOutput, String name, Supplier<? extends ItemLike> capsuleCore, int coreLevel, Supplier<? extends ItemLike> capsuleIngredient, ItemStack result, int craftingTime, int resultWeight, List<CoreTableRecipe.ResultOption> additionalResults) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"cobblecapsule", (String)("core_table/" + name));
        Advancement.Builder advancement = recipeOutput.advancement().parent(ROOT_RECIPE_ADVANCEMENT).addCriterion("has_corelink_activator", ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CORELINK_ACTIVATOR.get()))).addCriterion("has_capsule_core", ModRecipeProvider.has((ItemLike)capsuleCore.get())).addCriterion("has_focus_core", ModRecipeProvider.has((ItemLike)capsuleIngredient.get())).addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.AND);
        recipeOutput.accept(id, (Recipe)new CoreTableRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CORELINK_ACTIVATOR.get()}), new CoreTableRecipe.CoreRequirement(Ingredient.of((ItemLike[])new ItemLike[]{capsuleCore.get()}), coreLevel), Ingredient.of((ItemLike[])new ItemLike[]{capsuleIngredient.get()}), result, craftingTime, resultWeight, additionalResults), advancement.build(id.withPrefix("recipes/core_table/")));
    }

    private static Item getExternalItem(String modId, String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)modId, (String)path);
        return (Item)BuiltInRegistries.ITEM.getOptional(id).orElseThrow(() -> new IllegalStateException("Missing item in registry: " + String.valueOf(id)));
    }
}

