/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.datagen;

import java.util.Set;
import net.levelscraft7.cobblecapsule.block.ModBlocks;
import net.levelscraft7.cobblecapsule.item.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModBlockLootTableProvider
extends BlockLootSubProvider {
    public ModBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.dropSelf((Block)ModBlocks.CORE_TABLE.get());
        this.dropSelf((Block)ModBlocks.DISPLAY_CASE.get());
        this.dropSelf((Block)ModBlocks.CORELITE_BLOCK.get());
        this.add((Block)ModBlocks.CORELITE_ORE.get(), block -> this.createOreDrops((Block)ModBlocks.CORELITE_ORE.get(), (Item)ModItems.CORELITE_SHARD.get(), 1.0f, 1.0f));
        this.add((Block)ModBlocks.CORELITE_NETHER_ORE.get(), block -> this.createOreDrops((Block)ModBlocks.CORELITE_NETHER_ORE.get(), (Item)ModItems.CORELITE_SHARD.get(), 1.0f, 1.0f));
        this.add((Block)ModBlocks.CORELITE_END_ORE.get(), block -> this.createOreDrops((Block)ModBlocks.CORELITE_END_ORE.get(), (Item)ModItems.CORELITE_SHARD.get(), 1.0f, 1.0f));
        this.add((Block)ModBlocks.CORELITE_DEEPSLATE_ORE.get(), block -> this.createOreDrops((Block)ModBlocks.CORELITE_DEEPSLATE_ORE.get(), (Item)ModItems.CORELITE_SHARD.get(), 1.0f, 2.0f));
    }

    private LootTable.Builder createOreDrops(Block block, Item drop, float min, float max) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

