/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.levelscraft7.cobblecapsule.block.ModBlocks;
import net.levelscraft7.cobblecapsule.compat.jei.CoreTableJeiPlugin;
import net.levelscraft7.cobblecapsule.item.ModItems;
import net.levelscraft7.cobblecapsule.recipe.CoreTableRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CoreTableRecipeCategory
implements IRecipeCategory<CoreTableRecipe> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cobblecapsule", (String)"textures/gui/core_table.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public CoreTableRecipeCategory(IGuiHelper guiHelper) {
        IDrawableStatic arrowStatic = guiHelper.drawableBuilder(TEXTURE, 177, 1, 22, 17).build();
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 176, 85).build();
        this.arrow = guiHelper.createAnimatedDrawable(arrowStatic, 72, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CORE_TABLE.get()));
    }

    public RecipeType<CoreTableRecipe> getRecipeType() {
        return CoreTableJeiPlugin.CORE_TABLE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.cobblecapsule.core_table");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CoreTableRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 33, 37).addIngredients(recipe.getActivatorIngredient());
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 37).addIngredients(recipe.getCoreIngredient());
        builder.addSlot(RecipeIngredientRole.INPUT, 69, 37).addIngredients(recipe.getCapsuleIngredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 123, 37).addItemStacks(recipe.getDisplayResults());
    }

    public void draw(CoreTableRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.arrow.draw(graphics, 93, 36);
        RenderSystem.disableBlend();
        Font font = Minecraft.getInstance().font;
        int coreLevel = recipe.getRequiredCoreLevel();
        double seconds = (double)recipe.craftingTime() / 20.0;
        MutableComponent coreLevelText = Component.translatable((String)"tooltip.cobblecapsule.core_table.core_level", (Object[])new Object[]{coreLevel});
        MutableComponent timeText = Component.translatable((String)"tooltip.cobblecapsule.core_table.crafting_time", (Object[])new Object[]{recipe.craftingTime(), String.format(Locale.ROOT, "%.1f", seconds)});
        graphics.drawString(font, (Component)coreLevelText, 8, 8, 0x404040, false);
        graphics.drawString(font, (Component)timeText, 8, 20, 0x404040, false);
        if (CoreTableRecipeCategory.shouldShowResultChances(recipe, mouseX, mouseY)) {
            MutableComponent header = Component.translatable((String)"tooltip.cobblecapsule.core_table.result_chance_header");
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)header);
            for (CoreTableRecipe.ResultChance chance : recipe.getResultChances()) {
                String percent = String.format(Locale.ROOT, "%.1f", chance.percentage());
                tooltip.add((Component)Component.translatable((String)"tooltip.cobblecapsule.core_table.result_chance_entry", (Object[])new Object[]{chance.stack().getHoverName(), percent}));
            }
            int tooltipWidth = CoreTableRecipeCategory.getTooltipWidth(font, tooltip);
            int tooltipHeight = CoreTableRecipeCategory.getTooltipHeight(font, tooltip);
            int tooltipX = (int)mouseX - 12 - tooltipWidth;
            int tooltipY = (int)mouseY - tooltipHeight / 2;
            int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            if (tooltipX < 4) {
                tooltipX = 4;
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            }
            if (tooltipY + tooltipHeight > screenHeight - 4) {
                tooltipY = screenHeight - 4 - tooltipHeight;
            }
            graphics.renderComponentTooltip(font, tooltip, tooltipX, tooltipY);
        }
    }

    private static boolean shouldShowResultChances(CoreTableRecipe recipe, double mouseX, double mouseY) {
        return recipe.hasAdditionalResults() && CoreTableRecipeCategory.isPokemonCapsuleRecipe(recipe) && CoreTableRecipeCategory.isMouseOverArrow(mouseX, mouseY);
    }

    private static boolean isPokemonCapsuleRecipe(CoreTableRecipe recipe) {
        ItemStack result = recipe.getResultStack();
        return result.is((Item)ModItems.POKEMON_CAPSULE.get()) || result.is((Item)ModItems.POKEMON_CAPSULE_SHINY.get());
    }

    private static boolean isMouseOverArrow(double mouseX, double mouseY) {
        int x = 93;
        int y = 36;
        int width = 22;
        int height = 17;
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    private static int getTooltipWidth(Font font, List<Component> tooltip) {
        int maxWidth = 0;
        for (Component component : tooltip) {
            maxWidth = Math.max(maxWidth, font.width((FormattedText)component));
        }
        return maxWidth + 8;
    }

    private static int getTooltipHeight(Font font, List<Component> tooltip) {
        if (tooltip.isEmpty()) {
            return 0;
        }
        Objects.requireNonNull(font);
        int lineHeight = 9 + 1;
        return 8 + (tooltip.size() - 1) * lineHeight;
    }
}

