/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.compat.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.levelscraft7.cobblecapsule.block.ModBlocks;
import net.levelscraft7.cobblecapsule.compat.jei.CapsuleLootRecipe;
import net.levelscraft7.cobblecapsule.compat.jei.CapsuleLootRecipeCategory;
import net.levelscraft7.cobblecapsule.compat.jei.CoreTableRecipeCategory;
import net.levelscraft7.cobblecapsule.item.capsule.LootCapsuleItem;
import net.levelscraft7.cobblecapsule.menu.CoreTableMenu;
import net.levelscraft7.cobblecapsule.menu.ModMenuTypes;
import net.levelscraft7.cobblecapsule.recipe.CoreTableRecipe;
import net.levelscraft7.cobblecapsule.recipe.ModRecipes;
import net.levelscraft7.cobblecapsule.screen.CoreTableScreen;
import net.levelscraft7.cobblecapsule.util.CapsuleLootManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CoreTableJeiPlugin
implements IModPlugin {
    static final RecipeType<CoreTableRecipe> CORE_TABLE_RECIPE_TYPE = RecipeType.create((String)"cobblecapsule", (String)"core_table", CoreTableRecipe.class);
    static final RecipeType<CapsuleLootRecipe> CAPSULE_LOOT_RECIPE_TYPE = RecipeType.create((String)"cobblecapsule", (String)"capsule_loot", CapsuleLootRecipe.class);
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"cobblecapsule", (String)"core_table");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CoreTableRecipeCategory(registration.getJeiHelpers().getGuiHelper()), new CapsuleLootRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        List<CoreTableRecipe> recipes = level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.CORE_TABLE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(CORE_TABLE_RECIPE_TYPE, recipes);
        List capsuleLootRecipes = CoreTableJeiPlugin.getLootCapsuleItems().stream().map(capsule -> CapsuleLootManager.getDisplay(capsule.getLootTable()).map(display -> CoreTableJeiPlugin.createPagedLootRecipes(capsule, display))).flatMap(Optional::stream).flatMap(Collection::stream).toList();
        registration.addRecipes(CAPSULE_LOOT_RECIPE_TYPE, capsuleLootRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CORE_TABLE.get()), new RecipeType[]{CORE_TABLE_RECIPE_TYPE});
        CoreTableJeiPlugin.getLootCapsuleItems().forEach(capsule -> registration.addRecipeCatalyst(new ItemStack((ItemLike)capsule), new RecipeType[]{CAPSULE_LOOT_RECIPE_TYPE}));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CoreTableScreen.class, 93, 36, 22, 17, new RecipeType[]{CORE_TABLE_RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CoreTableMenu.class, (MenuType)ModMenuTypes.CORE_TABLE_MENU.get(), CORE_TABLE_RECIPE_TYPE, 0, 3, 4, 36);
    }

    private static List<LootCapsuleItem> getLootCapsuleItems() {
        return BuiltInRegistries.ITEM.stream().filter(item -> item instanceof LootCapsuleItem).filter(item -> "cobblecapsule".equals(BuiltInRegistries.ITEM.getKey(item).getNamespace())).map(item -> (LootCapsuleItem)((Object)item)).collect(Collectors.toList());
    }

    private static List<CapsuleLootRecipe> createPagedLootRecipes(LootCapsuleItem capsule, CapsuleLootManager.CapsuleLootDisplay display) {
        List<CapsuleLootManager.CapsuleLootDisplayEntry> entries = display.entries();
        if (entries.isEmpty()) {
            return List.of(new CapsuleLootRecipe(new ItemStack((ItemLike)capsule), display, capsule.allowsDuplicates() && display.allowDuplicates(), List.of()));
        }
        ArrayList<CapsuleLootRecipe> recipes = new ArrayList<CapsuleLootRecipe>();
        int pageSize = 54;
        for (int index = 0; index < entries.size(); index += pageSize) {
            int toIndex = Math.min(index + pageSize, entries.size());
            List<CapsuleLootManager.CapsuleLootDisplayEntry> pageEntries = entries.subList(index, toIndex);
            recipes.add(new CapsuleLootRecipe(new ItemStack((ItemLike)capsule), display, capsule.allowsDuplicates() && display.allowDuplicates(), pageEntries));
        }
        return recipes;
    }
}

