/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.compat.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.levelscraft7.cobblecapsule.compat.jei.CapsuleLootRecipe;
import net.levelscraft7.cobblecapsule.compat.jei.CoreTableJeiPlugin;
import net.levelscraft7.cobblecapsule.item.ModItems;
import net.levelscraft7.cobblecapsule.util.CapsuleLootManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CapsuleLootRecipeCategory
implements IRecipeCategory<CapsuleLootRecipe> {
    private static final int SLOT_SIZE = 20;
    private static final int SLOT_COLUMNS = 9;
    private static final int SLOT_ROWS = 6;
    static final int SLOTS_PER_PAGE = 54;
    private static final int SLOT_X_START = 0;
    private static final int SLOT_Y_START = 42;
    private final IDrawable background;
    private final IDrawable icon;

    public CapsuleLootRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(176, 162);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.HEALING_CAPSULE_BASIC.get()));
    }

    public RecipeType<CapsuleLootRecipe> getRecipeType() {
        return CoreTableJeiPlugin.CAPSULE_LOOT_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.%s.category.capsule_loot".formatted("cobblecapsule"));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CapsuleLootRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 8).addItemStack(recipe.capsuleStack());
        List<CapsuleLootManager.CapsuleLootDisplayEntry> entries = recipe.entries();
        for (int index = 0; index < entries.size(); ++index) {
            CapsuleLootManager.CapsuleLootDisplayEntry entry = entries.get(index);
            int column = index % 9;
            int row = index / 9;
            int x = 0 + column * 20;
            int y = 42 + row * 20;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(entry.stack().copy())).addRichTooltipCallback((slotView, tooltipBuilder) -> {
                int max;
                int min = entry.minCount();
                MutableComponent countComponent = min == (max = entry.maxCount()) ? Component.translatable((String)"tooltip.%s.capsule_loot.entry.stack.single".formatted("cobblecapsule"), (Object[])new Object[]{min}) : Component.translatable((String)"tooltip.%s.capsule_loot.entry.stack.range".formatted("cobblecapsule"), (Object[])new Object[]{min, max});
                tooltipBuilder.add((FormattedText)countComponent.withStyle(ChatFormatting.GRAY));
                MutableComponent weightComponent = Component.translatable((String)"tooltip.%s.capsule_loot.entry.weight".formatted("cobblecapsule"), (Object[])new Object[]{entry.weight()});
                tooltipBuilder.add((FormattedText)weightComponent.withStyle(ChatFormatting.DARK_GRAY));
            });
        }
    }

    public void draw(CapsuleLootRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        Font font = Minecraft.getInstance().font;
        MutableComponent rollsComponent = recipe.minRolls() == recipe.maxRolls() ? Component.translatable((String)"tooltip.%s.capsule_loot.rolls.single".formatted("cobblecapsule"), (Object[])new Object[]{recipe.minRolls()}) : Component.translatable((String)"tooltip.%s.capsule_loot.rolls.range".formatted("cobblecapsule"), (Object[])new Object[]{recipe.minRolls(), recipe.maxRolls()});
        MutableComponent duplicatesComponent = Component.translatable((String)(recipe.allowDuplicates() ? "tooltip.%s.capsule_loot.duplicates.allowed".formatted("cobblecapsule") : "tooltip.%s.capsule_loot.duplicates.blocked".formatted("cobblecapsule")));
        MutableComponent entriesComponent = Component.translatable((String)"tooltip.%s.capsule_loot.entry_count".formatted("cobblecapsule"), (Object[])new Object[]{recipe.totalEntries()});
        guiGraphics.drawString(font, (Component)rollsComponent, 32, 10, 0x404040, false);
        guiGraphics.drawString(font, (Component)duplicatesComponent, 32, 20, 0x404040, false);
        guiGraphics.drawString(font, (Component)entriesComponent, 32, 30, 0x404040, false);
    }
}

