/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.levelscraft7.cobblecapsule.block.entity.DisplayCaseBlockEntity;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DisplayCaseRenderer
implements BlockEntityRenderer<DisplayCaseBlockEntity> {
    private static final float ROTATION_SPEED_DEGREES = 1.5f;
    private static final float SPAWN_ANIM_DURATION_TICKS = 20.0f;
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();

    public DisplayCaseRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(DisplayCaseBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float age;
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = blockEntity.getBlockPos();
        ItemStack stack = blockEntity.getRenderItem();
        if (stack.isEmpty()) {
            return;
        }
        long spawnTime = blockEntity.getLastPlacedGameTime();
        float time = (float)level.getGameTime() + partialTick;
        float rotation = time * 1.5f % 360.0f;
        float baseScale = 0.62f;
        float yOffset = 0.0f;
        if (spawnTime != Long.MIN_VALUE && (age = (float)level.getGameTime() + partialTick - (float)spawnTime) >= 0.0f && age <= 20.0f) {
            float t = age / 20.0f;
            float ease = 1.0f - (float)Math.pow(1.0f - t, 3.0);
            yOffset = 0.15f * (float)Math.sin(ease * (float)Math.PI);
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.6 + (double)yOffset, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.scale(baseScale, baseScale, baseScale);
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)blockEntity.getBlockPos().above());
        this.itemRenderer.renderStatic(stack, ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, level, blockEntity.getBlockPos().hashCode());
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(DisplayCaseBlockEntity blockEntity) {
        return true;
    }
}

