/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.levelscraft7.cobblecapsule.block.entity.CoreTableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CoreTableRenderer
implements BlockEntityRenderer<CoreTableBlockEntity> {
    private final ItemRenderer itemRenderer;

    public CoreTableRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(CoreTableBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack core = blockEntity.getCore();
        if (core.isEmpty()) {
            return;
        }
        Level level = blockEntity.getLevel();
        if (level == null) {
            level = Minecraft.getInstance().level;
        }
        float time = level != null ? (float)level.getGameTime() + partialTick : partialTick;
        float hover = Mth.sin((float)(time / 10.0f)) * 0.1f + 0.15f;
        float rotation = time * 3.0f % 360.0f;
        poseStack.pushPose();
        poseStack.translate(0.5, 1.15 + (double)hover, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.scale(0.75f, 0.75f, 0.75f);
        this.itemRenderer.renderStatic(core, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, level, blockEntity.getBlockPos().hashCode());
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(CoreTableBlockEntity blockEntity) {
        return true;
    }
}

