/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.block.entity;

import java.util.Objects;
import java.util.UUID;
import net.levelscraft7.cobblecapsule.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayCaseBlockEntity
extends BlockEntity
implements Clearable {
    private static final String ITEM_TAG = "Item";
    private static final String LAST_PLACED_TAG = "LastPlacedGameTime";
    private static final int REMOVAL_COOLDOWN_TICKS = 10;
    private ItemStack displayedItem = ItemStack.EMPTY;
    private long lastPlacedGameTime = Long.MIN_VALUE;
    private long clientAnimationStartGameTime = Long.MIN_VALUE;
    private ItemStack clientPreviewItem = ItemStack.EMPTY;
    @Nullable
    private UUID lastPlacingPlayer;

    public DisplayCaseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DISPLAY_CASE.get(), pos, state);
    }

    public ItemStack getDisplayedItem() {
        return this.displayedItem;
    }

    public ItemStack getRenderItem() {
        if (this.level != null && this.level.isClientSide && !this.clientPreviewItem.isEmpty()) {
            return this.clientPreviewItem;
        }
        return this.displayedItem;
    }

    public boolean isEmpty() {
        return this.displayedItem.isEmpty();
    }

    public long getLastPlacedGameTime() {
        return this.lastPlacedGameTime;
    }

    public long getAnimationStartGameTime(Level level) {
        if (level != null && level.isClientSide && this.clientAnimationStartGameTime != Long.MIN_VALUE) {
            return this.clientAnimationStartGameTime;
        }
        return this.lastPlacedGameTime;
    }

    public void startClientAnimation(Level level) {
        if (level != null) {
            this.clientAnimationStartGameTime = level.getGameTime();
        }
    }

    public void applyClientPreview(ItemStack stack) {
        Level level = this.getLevel();
        if (level == null || !level.isClientSide || stack.isEmpty()) {
            return;
        }
        this.clientPreviewItem = stack.copyWithCount(1);
        this.startClientAnimation(level);
        this.setChanged();
        level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public void setDisplayedItem(ItemStack stack) {
        if (stack.isEmpty()) {
            this.removeDisplayedItem();
            return;
        }
        this.setDisplayedItemInternal(stack);
        this.broadcastChanges();
    }

    public ItemStack removeDisplayedItem() {
        if (this.displayedItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack removed = this.clearDisplayedItemInternal();
        this.broadcastChanges();
        return removed;
    }

    public void markJustPlaced(Level level, @Nullable Player player) {
        if (level != null) {
            this.lastPlacedGameTime = level.getGameTime();
            if (level.isClientSide) {
                this.clientAnimationStartGameTime = this.lastPlacedGameTime;
            }
            System.out.println("[DisplayCaseBE] markJustPlaced side=" + (level.isClientSide ? "CLIENT" : "SERVER") + " pos=" + String.valueOf(this.worldPosition) + " time=" + this.lastPlacedGameTime);
        }
        this.lastPlacingPlayer = player != null ? player.getUUID() : null;
    }

    public boolean canRemove(Level level, @Nullable Player player) {
        if (level == null) {
            return true;
        }
        long gameTime = level.getGameTime();
        if (gameTime <= this.lastPlacedGameTime) {
            return false;
        }
        if (player != null && Objects.equals(this.lastPlacingPlayer, player.getUUID())) {
            return gameTime - this.lastPlacedGameTime > 10L;
        }
        return true;
    }

    private void broadcastChanges() {
        this.setChanged();
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DisplayCaseBlockEntity.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)state);
            serverLevel.getChunkSource().blockChanged(this.worldPosition);
            this.syncToNearbyPlayers(serverLevel);
        }
    }

    private void syncToNearbyPlayers(ServerLevel serverLevel) {
        Packet<ClientGamePacketListener> updatePacket = this.getUpdatePacket();
        if (updatePacket == null) {
            return;
        }
        Vec3 center = Vec3.atCenterOf((Vec3i)this.worldPosition);
        double maxDistanceSq = 16384.0;
        for (ServerPlayer player : serverLevel.players()) {
            if (!(player.distanceToSqr(center) <= maxDistanceSq)) continue;
            player.connection.send(updatePacket);
        }
    }

    public void syncDirectly(@Nullable Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Packet<ClientGamePacketListener> updatePacket = this.getUpdatePacket();
        if (updatePacket != null) {
            serverPlayer.connection.send(updatePacket);
        }
    }

    private void setDisplayedItemInternal(ItemStack stack) {
        this.displayedItem = stack.copyWithCount(1);
    }

    private ItemStack clearDisplayedItemInternal() {
        if (this.displayedItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack removed = this.displayedItem;
        this.displayedItem = ItemStack.EMPTY;
        this.lastPlacedGameTime = Long.MIN_VALUE;
        this.lastPlacingPlayer = null;
        this.clientAnimationStartGameTime = Long.MIN_VALUE;
        this.clientPreviewItem = ItemStack.EMPTY;
        return removed;
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        ItemStack previous = this.displayedItem;
        long previousServerPlacement = this.lastPlacedGameTime;
        this.displayedItem = tag.contains(ITEM_TAG, 10) ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(ITEM_TAG)) : ItemStack.EMPTY;
        this.lastPlacedGameTime = tag.contains(LAST_PLACED_TAG) ? tag.getLong(LAST_PLACED_TAG) : Long.MIN_VALUE;
        this.setChanged();
        if (this.level != null && this.level.isClientSide) {
            boolean placementChanged;
            boolean hadRenderableBefore = !previous.isEmpty() || !this.clientPreviewItem.isEmpty();
            boolean hasRenderableNow = !this.displayedItem.isEmpty();
            boolean bl = placementChanged = this.lastPlacedGameTime != previousServerPlacement;
            if (!hasRenderableNow) {
                this.clientAnimationStartGameTime = Long.MIN_VALUE;
            } else if (!hadRenderableBefore || placementChanged) {
                this.clientAnimationStartGameTime = this.level.getGameTime();
            }
            this.clientPreviewItem = ItemStack.EMPTY;
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.displayedItem.isEmpty()) {
            tag.put(ITEM_TAG, this.displayedItem.saveOptional(provider));
        }
        tag.putLong(LAST_PLACED_TAG, this.lastPlacedGameTime);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(@NotNull Connection connection, ClientboundBlockEntityDataPacket packet, @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, provider);
        }
    }

    public void clearContent() {
    }
}

