/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.block.entity;

import java.util.Optional;
import net.levelscraft7.cobblecapsule.block.ModBlocks;
import net.levelscraft7.cobblecapsule.block.custom.CoreTableBlock;
import net.levelscraft7.cobblecapsule.block.entity.ModBlockEntities;
import net.levelscraft7.cobblecapsule.item.ModItems;
import net.levelscraft7.cobblecapsule.menu.CoreTableMenu;
import net.levelscraft7.cobblecapsule.recipe.CoreTableRecipe;
import net.levelscraft7.cobblecapsule.recipe.CoreTableRecipeInput;
import net.levelscraft7.cobblecapsule.recipe.ModRecipes;
import net.levelscraft7.cobblecapsule.util.CapsuleSoundHelper;
import net.levelscraft7.cobblecapsule.util.LevelUtils;
import net.levelscraft7.cobblecapsule.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.extensions.IMenuProviderExtension;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreTableBlockEntity
extends BlockEntity
implements MenuProvider,
Clearable,
IMenuProviderExtension,
WorldlyContainer {
    public static final int SLOT_CORELINK = 0;
    public static final int SLOT_CORE = 1;
    public static final int SLOT_CAPSULE_INPUT = 2;
    public static final int SLOT_OUTPUT = 3;
    private static final int INVENTORY_SIZE = 4;
    private static final String INVENTORY_TAG = "Inventory";
    private static final String PROGRESS_TAG = "Progress";
    private static final String MAX_PROGRESS_TAG = "MaxProgress";
    private static final String CRAFT_READY_TAG = "CraftReady";
    private static final String ACTIVE_RECIPE_TAG = "ActiveRecipe";
    private static final int DEFAULT_MAX_PROGRESS = 72;
    private static final int[] SIDE_INPUT_SLOTS = new int[]{0, 1, 2};
    private static final int[] DOWN_OUTPUT_SLOTS = new int[]{3};
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        private void ensureSlotCount() {
            if (this.stacks.size() == 4) {
                return;
            }
            NonNullList resized = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
            for (int i = 0; i < Math.min(this.stacks.size(), 4); ++i) {
                resized.set(i, (Object)((ItemStack)this.stacks.get(i)));
            }
            this.stacks = resized;
        }

        protected void onContentsChanged(int slot) {
            if (CoreTableBlockEntity.this.suppressItemHandlerUpdates) {
                return;
            }
            CoreTableBlockEntity.this.setChanged();
            if (slot == 1) {
                CoreTableBlockEntity.this.handleCoreSlotChanged();
                CoreTableBlockEntity.this.cancelCraftIfInputsChanged();
            } else if (slot == 2) {
                CoreTableBlockEntity.this.cancelCraftIfInputsChanged();
            } else {
                if (slot != 3) {
                    CoreTableBlockEntity.this.cancelCraftIfInputsChanged();
                }
                if (!LevelUtils.isClient(CoreTableBlockEntity.this.level)) {
                    CoreTableBlockEntity.this.syncToClient();
                }
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.is((Item)ModItems.CORELINK_ACTIVATOR.get());
                case 1 -> CoreTableBlock.isCoreItem(stack);
                case 2 -> stack.is(ModTags.Items.CORE_TABLE_INGREDIENTS);
                case 3 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }

        public int getSlotLimit(int slot) {
            if (slot == 1 || slot == 2) {
                return 16;
            }
            return super.getSlotLimit(slot);
        }

        public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            super.deserializeNBT(provider, nbt);
            this.ensureSlotCount();
        }
    };
    private final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> CoreTableBlockEntity.this.progress;
                case 1 -> CoreTableBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    CoreTableBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    CoreTableBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;
    private boolean craftReady = false;
    private boolean suppressItemHandlerUpdates = false;
    @Nullable
    private ResourceLocation activeRecipeId = null;

    public CoreTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CORE_TABLE.get(), pos, state);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"container.cobblecapsule.core_table");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory inventory, @NotNull Player player) {
        return new CoreTableMenu(containerId, inventory, this, this.dataAccess);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            if (this.itemHandler.getStackInSlot(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        if (count <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack extracted = this.itemHandler.extractItem(index, count, false);
        if (index == 3) {
            this.handleAutomationOutputRemoval();
        }
        return extracted;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack toReturn = stack.copy();
        this.itemHandler.setStackInSlot(index, ItemStack.EMPTY);
        if (index == 3) {
            this.handleAutomationOutputRemoval();
        }
        return toReturn;
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        this.itemHandler.setStackInSlot(index, stack);
    }

    public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
        return this.itemHandler.isItemValid(index, stack);
    }

    public boolean stillValid(@NotNull Player player) {
        if (this.level == null) {
            return false;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (!state.is((Block)ModBlocks.CORE_TABLE.get())) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public boolean hasActiveRecipe() {
        return this.activeRecipeId != null;
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        if (side == Direction.DOWN) {
            return DOWN_OUTPUT_SLOTS;
        }
        if (side == Direction.UP) {
            return new int[0];
        }
        return SIDE_INPUT_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        if (direction == Direction.DOWN || direction == Direction.UP) {
            return false;
        }
        return switch (index) {
            case 0, 1, 2 -> {
                if (this.canStackWithExisting(index, stack) && this.itemHandler.isItemValid(index, stack)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (direction == Direction.DOWN) {
            return index == 3;
        }
        return false;
    }

    private boolean canStackWithExisting(int slot, ItemStack incoming) {
        if (incoming.isEmpty()) {
            return false;
        }
        ItemStack existing = this.itemHandler.getStackInSlot(slot);
        if (existing.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)incoming)) {
            return false;
        }
        int limit = Math.min(existing.getMaxStackSize(), this.itemHandler.getSlotLimit(slot));
        return existing.getCount() < limit;
    }

    public ItemStack getCore() {
        ItemStack stack = this.itemHandler.getStackInSlot(1);
        return stack.isEmpty() ? ItemStack.EMPTY : stack.copy();
    }

    public void setCore(ItemStack stack) {
        ItemStack single;
        ItemStack itemStack = single = stack.isEmpty() ? ItemStack.EMPTY : stack.copyWithCount(1);
        if (!single.isEmpty() && !CoreTableBlock.isCoreItem(single)) {
            return;
        }
        this.itemHandler.setStackInSlot(1, single);
    }

    public ItemStack removeCore() {
        ItemStack removed = this.itemHandler.getStackInSlot(1);
        if (removed.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
        return removed.copy();
    }

    private void handleCoreSlotChanged() {
        if (this.level == null) {
            return;
        }
        ItemStack core = this.itemHandler.getStackInSlot(1);
        int newLevel = CoreTableBlock.getCoreLevel(core);
        BlockState state = this.getBlockState();
        if (!state.hasProperty((Property)CoreTableBlock.CORE_LEVEL)) {
            this.syncToClient();
            return;
        }
        if (!LevelUtils.isClient(this.level)) {
            int currentLevel = (Integer)state.getValue((Property)CoreTableBlock.CORE_LEVEL);
            if (currentLevel != newLevel) {
                BlockState newState = (BlockState)state.setValue((Property)CoreTableBlock.CORE_LEVEL, (Comparable)Integer.valueOf(newLevel));
                this.level.setBlock(this.worldPosition, newState, 3);
                this.level.sendBlockUpdated(this.worldPosition, state, newState, 2);
            } else {
                this.syncToClient();
            }
        }
    }

    public void writeClientSideData(@NotNull AbstractContainerMenu menu, @NotNull RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.getBlockPos());
    }

    public void clearContent() {
        for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            this.itemHandler.setStackInSlot(slot, ItemStack.EMPTY);
        }
        this.setChanged();
        this.syncToClient();
    }

    public void onLoad() {
        super.onLoad();
        this.handleCoreSlotChanged();
    }

    private void syncToClient() {
        if (this.level != null && !LevelUtils.isClient(this.level)) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CoreTableBlockEntity blockEntity) {
        if (LevelUtils.isClient(level)) {
            return;
        }
        if (blockEntity.getCore().isEmpty()) {
            blockEntity.resetProgressAndOutput();
            return;
        }
        Optional<CoreTableRecipe> activeRecipe = blockEntity.ensureActiveRecipe();
        if (activeRecipe.isEmpty()) {
            blockEntity.resetProgressAndOutput();
            return;
        }
        CoreTableRecipe recipe = activeRecipe.get();
        if (!blockEntity.isRecipeStillValid(recipe)) {
            blockEntity.resetProgressAndOutput();
            return;
        }
        blockEntity.maxProgress = recipe.craftingTime();
        if (!blockEntity.canOutputResult(recipe)) {
            blockEntity.resetProgress();
            return;
        }
        ++blockEntity.progress;
        if (blockEntity.progress >= blockEntity.maxProgress) {
            blockEntity.progress = blockEntity.maxProgress;
            blockEntity.craftReady = true;
            blockEntity.ensureOutputMatches(recipe);
        } else {
            blockEntity.clearOutputSlot();
        }
        CoreTableBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    private Optional<CoreTableRecipe> ensureActiveRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        Optional<CoreTableRecipe> active = this.getActiveRecipe();
        if (active.isPresent()) {
            return active;
        }
        Optional<RecipeHolder<CoreTableRecipe>> match = this.findMatchingRecipe();
        if (match.isEmpty()) {
            return Optional.empty();
        }
        this.startCraft(match.get());
        return Optional.of((CoreTableRecipe)match.get().value());
    }

    private Optional<RecipeHolder<CoreTableRecipe>> findMatchingRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        CoreTableRecipeInput input = new CoreTableRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(2));
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.CORE_TABLE_TYPE.get(), (RecipeInput)input, this.level);
    }

    private Optional<CoreTableRecipe> getActiveRecipe() {
        if (this.level == null || this.activeRecipeId == null) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().byKey(this.activeRecipeId).flatMap(holder -> {
            Recipe patt0$temp = holder.value();
            if (patt0$temp instanceof CoreTableRecipe) {
                CoreTableRecipe recipe = (CoreTableRecipe)patt0$temp;
                return Optional.of(recipe);
            }
            return Optional.empty();
        });
    }

    private void startCraft(RecipeHolder<CoreTableRecipe> holder) {
        this.activeRecipeId = holder.id();
        this.progress = 0;
        this.craftReady = false;
        this.maxProgress = ((CoreTableRecipe)holder.value()).craftingTime();
        this.setChanged();
        this.syncToClient();
    }

    private boolean isRecipeStillValid(CoreTableRecipe recipe) {
        ItemStack activator = this.itemHandler.getStackInSlot(0);
        ItemStack core = this.itemHandler.getStackInSlot(1);
        ItemStack capsule = this.itemHandler.getStackInSlot(2);
        if (!recipe.getActivatorIngredient().test(activator)) {
            return false;
        }
        if (!recipe.getCoreIngredient().test(core)) {
            return false;
        }
        if (!recipe.getCapsuleIngredient().test(capsule)) {
            return false;
        }
        int coreLevel = CoreTableBlock.getCoreLevel(core);
        return coreLevel == recipe.getRequiredCoreLevel();
    }

    private boolean canOutputResult(CoreTableRecipe recipe) {
        if (this.level == null) {
            return false;
        }
        ItemStack outputStack = this.itemHandler.getStackInSlot(3);
        if (outputStack.isEmpty()) {
            return true;
        }
        if (recipe.hasAdditionalResults()) {
            if (!this.craftReady) {
                return false;
            }
            Optional<ItemStack> match = recipe.findMatchingResult(outputStack);
            return match.isPresent() && outputStack.getCount() <= outputStack.getMaxStackSize();
        }
        ItemStack result = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (result.isEmpty()) {
            return false;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)result)) {
            return false;
        }
        return outputStack.getCount() + result.getCount() <= outputStack.getMaxStackSize();
    }

    private void ensureOutputMatches(CoreTableRecipe recipe) {
        if (this.level == null) {
            return;
        }
        ItemStack current = this.itemHandler.getStackInSlot(3);
        if (recipe.hasAdditionalResults()) {
            Optional<ItemStack> match = recipe.findMatchingResult(current);
            if (match.isPresent() && current.getCount() == match.get().getCount()) {
                return;
            }
            this.itemHandler.setStackInSlot(3, recipe.rollOutput(this.level.getRandom()));
            return;
        }
        ItemStack expected = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (current.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)expected) || current.getCount() != expected.getCount()) {
            this.itemHandler.setStackInSlot(3, expected.copy());
        }
    }

    private void clearOutputSlot() {
        ItemStack output = this.itemHandler.getStackInSlot(3);
        if (!output.isEmpty()) {
            this.itemHandler.setStackInSlot(3, ItemStack.EMPTY);
        }
    }

    private void withItemUpdatesSuppressed(Runnable action) {
        boolean previous = this.suppressItemHandlerUpdates;
        this.suppressItemHandlerUpdates = true;
        try {
            action.run();
        }
        finally {
            this.suppressItemHandlerUpdates = previous;
        }
    }

    private void resetProgress() {
        boolean changed = false;
        if (this.progress != 0) {
            this.progress = 0;
            changed = true;
        }
        if (this.craftReady) {
            this.craftReady = false;
            changed = true;
        }
        if (changed) {
            this.setChanged();
        }
    }

    private void resetProgressAndOutput() {
        this.clearOutputSlot();
        this.resetProgress();
        this.clearActiveRecipe();
    }

    private void clearActiveRecipe() {
        boolean changed = false;
        if (this.activeRecipeId != null) {
            this.activeRecipeId = null;
            changed = true;
        }
        if (this.maxProgress != 72) {
            this.maxProgress = 72;
            changed = true;
        }
        if (changed) {
            this.setChanged();
            this.syncToClient();
        }
    }

    private void cancelCraftIfInputsChanged() {
        if (this.level == null) {
            this.resetProgressAndOutput();
            return;
        }
        if (this.activeRecipeId == null) {
            if (this.craftReady || this.progress > 0) {
                this.resetProgressAndOutput();
            }
            return;
        }
        Optional<CoreTableRecipe> active = this.getActiveRecipe();
        if (active.isEmpty()) {
            this.resetProgressAndOutput();
            return;
        }
        if (this.isRecipeStillValid(active.get())) {
            return;
        }
        this.resetProgressAndOutput();
    }

    public void onResultTaken(@NotNull Player player, @NotNull ItemStack craftedStack) {
        Optional<CoreTableRecipe> match;
        if (this.level == null || LevelUtils.isClient(this.level) || !this.craftReady) {
            return;
        }
        if (!craftedStack.isEmpty()) {
            player.awardStat(Stats.ITEM_CRAFTED.get((Object)craftedStack.getItem()), craftedStack.getCount());
            CapsuleSoundHelper.resolveProfile(craftedStack).ifPresent(profile -> CapsuleSoundHelper.playCapsuleSound((ServerLevel)this.level, this.worldPosition, profile));
            if (CapsuleSoundHelper.shouldPlayRareFanfare(craftedStack)) {
                CapsuleSoundHelper.playRareDropFanfare((ServerLevel)this.level, player);
            }
        }
        if ((match = this.getActiveRecipe()).isEmpty()) {
            this.resetProgressAndOutput();
            return;
        }
        this.finalizeCraft(match.get());
    }

    private void damageActivator() {
        ItemStack activator = this.itemHandler.getStackInSlot(0);
        if (activator.isEmpty()) {
            return;
        }
        if (activator.isDamageableItem()) {
            activator.setDamageValue(activator.getDamageValue() + 1);
            if (activator.getDamageValue() >= activator.getMaxDamage()) {
                this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
            }
        } else {
            this.itemHandler.extractItem(0, 1, false);
        }
    }

    private void finalizeCraft(CoreTableRecipe recipe) {
        this.consumeCoreForCraft();
        this.consumeCapsuleForCraft(recipe);
        this.damageActivator();
        this.resetProgress();
        this.clearActiveRecipe();
    }

    private void consumeCoreForCraft() {
        ItemStack coreStack = this.itemHandler.getStackInSlot(1);
        if (!coreStack.isEmpty()) {
            this.itemHandler.extractItem(1, 1, false);
        }
    }

    private void handleAutomationOutputRemoval() {
        if (!this.craftReady) {
            return;
        }
        if (this.level == null || LevelUtils.isClient(this.level)) {
            return;
        }
        ItemStack remaining = this.itemHandler.getStackInSlot(3);
        if (!remaining.isEmpty()) {
            return;
        }
        Optional<CoreTableRecipe> match = this.getActiveRecipe();
        if (match.isEmpty()) {
            this.resetProgressAndOutput();
            return;
        }
        this.finalizeCraft(match.get());
    }

    private void consumeCapsuleForCraft(CoreTableRecipe recipe) {
        ItemStack capsuleStack = this.itemHandler.getStackInSlot(2);
        if (capsuleStack.isEmpty()) {
            return;
        }
        if (!recipe.getCapsuleIngredient().test(capsuleStack)) {
            return;
        }
        this.itemHandler.extractItem(2, 1, false);
    }

    public void drops() {
        if (this.level == null || LevelUtils.isClient(this.level)) {
            return;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        this.withItemUpdatesSuppressed(() -> {
            for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
                ItemStack stack = this.itemHandler.getStackInSlot(slot);
                if (stack.isEmpty()) continue;
                inventory.setItem(slot, stack.copy());
                this.itemHandler.setStackInSlot(slot, ItemStack.EMPTY);
            }
        });
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
        this.clearActiveRecipe();
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(INVENTORY_TAG)) {
            this.itemHandler.deserializeNBT(provider, tag.getCompound(INVENTORY_TAG));
        }
        this.progress = tag.getInt(PROGRESS_TAG);
        this.maxProgress = tag.contains(MAX_PROGRESS_TAG) ? tag.getInt(MAX_PROGRESS_TAG) : this.maxProgress;
        this.craftReady = tag.getBoolean(CRAFT_READY_TAG);
        this.activeRecipeId = tag.contains(ACTIVE_RECIPE_TAG) ? ResourceLocation.tryParse((String)tag.getString(ACTIVE_RECIPE_TAG)) : null;
        this.handleCoreSlotChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(INVENTORY_TAG, (Tag)this.itemHandler.serializeNBT(provider));
        tag.putInt(PROGRESS_TAG, this.progress);
        tag.putInt(MAX_PROGRESS_TAG, this.maxProgress);
        tag.putBoolean(CRAFT_READY_TAG, this.craftReady);
        if (this.activeRecipeId != null) {
            tag.putString(ACTIVE_RECIPE_TAG, this.activeRecipeId.toString());
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setBlockState(@NotNull BlockState state) {
        super.setBlockState(state);
        if (state.hasProperty((Property)CoreTableBlock.CORE_LEVEL) && (Integer)state.getValue((Property)CoreTableBlock.CORE_LEVEL) == 0 && !this.itemHandler.getStackInSlot(1).isEmpty()) {
            this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
        }
    }
}

