/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.block.custom;

import com.mojang.serialization.MapCodec;
import net.levelscraft7.cobblecapsule.block.entity.DisplayCaseBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DisplayCaseBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<DisplayCaseBlock> CODEC = DisplayCaseBlock.simpleCodec(DisplayCaseBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public DisplayCaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DisplayCaseBlockEntity(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DisplayCaseBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        DisplayCaseBlockEntity displayCase = (DisplayCaseBlockEntity)blockEntity;
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack displayedItem = displayCase.getDisplayedItem();
        if (displayCase.isEmpty()) {
            if (level.isClientSide) {
                this.previewPlacement(displayCase, stack);
            } else {
                this.placeItem(displayCase, level, pos, player, stack);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)displayedItem)) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (level.isClientSide) {
            this.previewPlacement(displayCase, stack);
        } else {
            this.swapDisplayedItem(displayCase, level, pos, player, stack);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DisplayCaseBlockEntity)) {
            return InteractionResult.PASS;
        }
        DisplayCaseBlockEntity displayCase = (DisplayCaseBlockEntity)blockEntity;
        return this.removeDisplayedItem(displayCase, level, pos, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        ItemStack removed;
        DisplayCaseBlockEntity displayCase;
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof DisplayCaseBlockEntity && !(displayCase = (DisplayCaseBlockEntity)blockEntity).isEmpty() && !(removed = displayCase.removeDisplayedItem()).isEmpty() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DisplayCaseBlock.popResource((Level)serverLevel, (BlockPos)pos, (ItemStack)removed);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void playPlacementSound(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.7f, 1.0f);
    }

    private void playPickupSound(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.6f, 1.1f);
    }

    private InteractionResult removeDisplayedItem(DisplayCaseBlockEntity displayCase, Level level, BlockPos pos, Player player) {
        if (displayCase.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!displayCase.canRemove(level, player)) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            displayCase.removeDisplayedItem();
            return InteractionResult.SUCCESS;
        }
        ItemStack removed = displayCase.removeDisplayedItem();
        if (removed.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!player.addItem(removed)) {
            DisplayCaseBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)removed);
        }
        this.playPickupSound(level, pos);
        return InteractionResult.CONSUME;
    }

    private void placeItem(DisplayCaseBlockEntity displayCase, Level level, BlockPos pos, Player player, ItemStack stack) {
        displayCase.markJustPlaced(level, player);
        displayCase.setDisplayedItem(stack.copyWithCount(1));
        displayCase.syncDirectly(player);
        this.playPlacementSound(level, pos);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
    }

    private void swapDisplayedItem(DisplayCaseBlockEntity displayCase, Level level, BlockPos pos, Player player, ItemStack stack) {
        ItemStack removed = displayCase.removeDisplayedItem();
        if (!removed.isEmpty()) {
            if (!player.addItem(removed)) {
                DisplayCaseBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)removed);
            }
            this.playPickupSound(level, pos);
        }
        this.placeItem(displayCase, level, pos, player, stack);
    }

    private void previewPlacement(DisplayCaseBlockEntity displayCase, ItemStack stack) {
        Level level = displayCase.getLevel();
        if (level == null || !level.isClientSide) {
            return;
        }
        displayCase.setDisplayedItem(stack.copyWithCount(1));
        displayCase.startClientAnimation(level);
    }
}

