/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.levelscraft7.cobblecapsule.block.entity.CoreTableBlockEntity;
import net.levelscraft7.cobblecapsule.item.ModItems;
import net.levelscraft7.cobblecapsule.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CoreTableBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<CoreTableBlock> CODEC = CoreTableBlock.simpleCodec(CoreTableBlock::new);
    public static final IntegerProperty CORE_LEVEL = IntegerProperty.create((String)"core_level", (int)0, (int)3);

    public CoreTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CORE_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CORE_LEVEL});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CoreTableBlockEntity(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Optional<CoreType> coreType = CoreType.fromItem(stack.getItem());
        if (coreType.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (LevelUtils.isClient(level)) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CoreTableBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        CoreTableBlockEntity tableBlockEntity = (CoreTableBlockEntity)blockEntity;
        if (((Integer)state.getValue((Property)CORE_LEVEL)).intValue() == coreType.get().level()) {
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack existingCore = tableBlockEntity.removeCore();
        if (!existingCore.isEmpty()) {
            if (!player.addItem(existingCore.copy())) {
                CoreTableBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)existingCore);
            }
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.6f, 1.1f);
        }
        ItemStack toStore = stack.copyWithCount(1);
        BlockState newState = (BlockState)state.setValue((Property)CORE_LEVEL, (Comparable)Integer.valueOf(coreType.get().level()));
        level.setBlock(pos, newState, 3);
        BlockEntity newEntity = level.getBlockEntity(pos);
        if (newEntity instanceof CoreTableBlockEntity) {
            CoreTableBlockEntity updatedTable = (CoreTableBlockEntity)newEntity;
            updatedTable.setCore(toStore);
            updatedTable.setChanged();
        }
        level.sendBlockUpdated(pos, state, newState, 2);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (LevelUtils.isClient(level)) {
            return InteractionResult.sidedSuccess((boolean)true);
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CoreTableBlockEntity)) {
            return InteractionResult.PASS;
        }
        CoreTableBlockEntity tableBlockEntity = (CoreTableBlockEntity)blockEntity;
        if (player.isShiftKeyDown()) {
            ItemStack existingCore = tableBlockEntity.removeCore();
            if (!existingCore.isEmpty()) {
                BlockState newState = (BlockState)state.setValue((Property)CORE_LEVEL, (Comparable)Integer.valueOf(0));
                level.setBlock(pos, newState, 3);
                if (!player.addItem(existingCore.copy())) {
                    CoreTableBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)existingCore);
                }
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.6f, 1.1f);
                level.sendBlockUpdated(pos, state, newState, 2);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)tableBlockEntity, pos);
        }
        return InteractionResult.sidedSuccess((boolean)LevelUtils.isClient(level));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof CoreTableBlockEntity) {
            CoreTableBlockEntity coreTableBlockEntity = (CoreTableBlockEntity)blockEntity;
            coreTableBlockEntity.drops();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (LevelUtils.isClient(level)) {
            return null;
        }
        return (lvl, blockPos, blockState, blockEntity) -> {
            if (blockEntity instanceof CoreTableBlockEntity) {
                CoreTableBlockEntity coreTableBlockEntity = (CoreTableBlockEntity)blockEntity;
                CoreTableBlockEntity.tick(lvl, blockPos, blockState, coreTableBlockEntity);
            }
        };
    }

    public static boolean isCoreItem(ItemStack stack) {
        return !stack.isEmpty() && CoreType.fromItem(stack.getItem()).isPresent();
    }

    public static int getCoreLevel(ItemStack stack) {
        return CoreType.fromItem(stack.getItem()).map(CoreType::level).orElse(0);
    }

    private static enum CoreType {
        BASIC(1, (Item)ModItems.CAPSULE_CORE_BASIC.get()),
        RARE(2, (Item)ModItems.CAPSULE_CORE_RARE.get()),
        EPIC(3, (Item)ModItems.CAPSULE_CORE_EPIC.get());

        private final int level;
        private final Item item;

        private CoreType(int level, Item item) {
            this.level = level;
            this.item = item;
        }

        public int level() {
            return this.level;
        }

        public Item item() {
            return this.item;
        }

        public static Optional<CoreType> fromItem(Item item) {
            for (CoreType type : CoreType.values()) {
                if (type.item != item) continue;
                return Optional.of(type);
            }
            return Optional.empty();
        }
    }
}

