/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule.block;

import java.util.List;
import java.util.function.Supplier;
import net.levelscraft7.cobblecapsule.block.custom.CoreTableBlock;
import net.levelscraft7.cobblecapsule.block.custom.DisplayCaseBlock;
import net.levelscraft7.cobblecapsule.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"cobblecapsule");
    public static final DeferredBlock<Block> CORELITE_ORE = ModBlocks.registerBlock("corelite_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.translatable((String)"tooltip.cobblecapsule.corelite_ore"));
            super.appendHoverText(stack, context, tooltip, flag);
        }
    });
    public static final DeferredBlock<Block> CORELITE_NETHER_ORE = ModBlocks.registerBlock("corelite_nether_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(3.5f).requiresCorrectToolForDrops().sound(SoundType.NETHER_ORE)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.translatable((String)"tooltip.cobblecapsule.corelite_ore"));
            super.appendHoverText(stack, context, tooltip, flag);
        }
    });
    public static final DeferredBlock<Block> CORELITE_END_ORE = ModBlocks.registerBlock("corelite_end_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(4.5f).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.translatable((String)"tooltip.cobblecapsule.corelite_ore"));
            super.appendHoverText(stack, context, tooltip, flag);
        }
    });
    public static final DeferredBlock<Block> CORELITE_DEEPSLATE_ORE = ModBlocks.registerBlock("corelite_deepslate_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)6), BlockBehaviour.Properties.of().strength(4.5f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.translatable((String)"tooltip.cobblecapsule.corelite_deepslate_ore"));
            super.appendHoverText(stack, context, tooltip, flag);
        }
    });
    public static final DeferredBlock<Block> CORELITE_BLOCK = ModBlocks.registerBlock("corelite_block", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.STONE)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.translatable((String)"tooltip.cobblecapsule.corelite_block"));
            super.appendHoverText(stack, context, tooltip, flag);
        }
    });
    public static final DeferredBlock<Block> CORE_TABLE = ModBlocks.registerBlock("core_table", () -> new CoreTableBlock(BlockBehaviour.Properties.of().noOcclusion().strength(6.0f).sound(SoundType.METAL)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.translatable((String)"tooltip.cobblecapsule.core_table").withStyle(ChatFormatting.AQUA));
            super.appendHoverText(stack, context, tooltip, flag);
        }
    });
    public static final DeferredBlock<Block> DISPLAY_CASE = ModBlocks.registerBlock("display_case", () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().noOcclusion().strength(2.0f).sound(SoundType.GLASS)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            tooltip.add((Component)Component.translatable((String)"tooltip.cobblecapsule.display_case").withStyle(ChatFormatting.AQUA));
            super.appendHoverText(stack, context, tooltip, flag);
        }
    });

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

