/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.levelscraft7.cobblecapsule.CobbleCapsule;
import net.neoforged.fml.loading.FMLPaths;

public final class WorldGenConfigGenerator {
    private static final String CONFIG_FILE_NAME = "world-gen.json";
    private static final String WORLD_GEN_CONFIG_RESOURCE = "/world-gen.json";

    private WorldGenConfigGenerator() {
    }

    public static void ensureWorldGenConfig() {
        Path configFile = FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE_NAME);
        if (Files.exists(configFile, new LinkOption[0])) {
            CobbleCapsule.LOGGER.debug("JER world-gen config already present at {}", (Object)configFile.toAbsolutePath());
            return;
        }
        try (InputStream resource = WorldGenConfigGenerator.class.getResourceAsStream(WORLD_GEN_CONFIG_RESOURCE);){
            if (resource == null) {
                CobbleCapsule.LOGGER.error("Missing bundled JER world-gen config resource at {}", (Object)WORLD_GEN_CONFIG_RESOURCE);
                return;
            }
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            Files.copy(resource, configFile, new CopyOption[0]);
            CobbleCapsule.LOGGER.info("Generating JER config to display Cobble Capsule ores in JEI via JER at {}", (Object)configFile.toAbsolutePath());
        }
        catch (IOException e) {
            CobbleCapsule.LOGGER.error("Failed to generate JER world-gen config at {}", (Object)configFile.toAbsolutePath(), (Object)e);
        }
    }
}

