/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule;

import net.minecraft.util.Mth;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
    static final ModConfigSpec SPEC = COMMON_BUILDER.build();
    private static final ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
    public static final Server SERVER = new Server(SERVER_BUILDER);
    public static final ModConfigSpec SERVER_SPEC = SERVER_BUILDER.build();
    private static final int DEFAULT_POKEMON_CAPSULE_MIN_LEVEL = 1;
    private static final int DEFAULT_POKEMON_CAPSULE_MAX_LEVEL = 100;
    private static final int DEFAULT_POKEMON_CAPSULE_SHINY_MIN_LEVEL = 1;
    private static final int DEFAULT_POKEMON_CAPSULE_SHINY_MAX_LEVEL = 100;
    private static final int DEFAULT_CAPSULE_STACK_SIZE = 16;
    private static final int DEFAULT_CORE_STACK_SIZE = 16;
    private static int pokemonCapsuleMinLevel = 1;
    private static int pokemonCapsuleMaxLevel = 100;
    private static int shinyPokemonCapsuleMinLevel = 1;
    private static int shinyPokemonCapsuleMaxLevel = 100;
    private static int capsuleStackSize = 16;
    private static int coreStackSize = 16;

    public static void onConfigEvent(ModConfigEvent event) {
        if (event.getConfig().getSpec() != SERVER_SPEC) {
            return;
        }
        if (event instanceof ModConfigEvent.Unloading) {
            Config.resetToDefaults();
            return;
        }
        pokemonCapsuleMinLevel = Config.clampLevel(Config.SERVER.pokemonCapsuleMinLevel);
        pokemonCapsuleMaxLevel = Config.clampLevel(Config.SERVER.pokemonCapsuleMaxLevel);
        shinyPokemonCapsuleMinLevel = Config.clampLevel(Config.SERVER.shinyPokemonCapsuleMinLevel);
        shinyPokemonCapsuleMaxLevel = Config.clampLevel(Config.SERVER.shinyPokemonCapsuleMaxLevel);
        capsuleStackSize = Config.clampStackLimit(Config.SERVER.capsuleStackSize);
        coreStackSize = Config.clampStackLimit(Config.SERVER.coreStackSize);
    }

    private static void resetToDefaults() {
        pokemonCapsuleMinLevel = 1;
        pokemonCapsuleMaxLevel = 100;
        shinyPokemonCapsuleMinLevel = 1;
        shinyPokemonCapsuleMaxLevel = 100;
        capsuleStackSize = 16;
        coreStackSize = 16;
    }

    private static int clampLevel(ModConfigSpec.IntValue value) {
        return Mth.clamp((int)((Integer)value.get()), (int)1, (int)100);
    }

    private static int clampStackLimit(ModConfigSpec.IntValue value) {
        return Mth.clamp((int)((Integer)value.get()), (int)1, (int)64);
    }

    public static int getPokemonCapsuleMinLevel(boolean shiny) {
        int min = shiny ? shinyPokemonCapsuleMinLevel : pokemonCapsuleMinLevel;
        int max = shiny ? shinyPokemonCapsuleMaxLevel : pokemonCapsuleMaxLevel;
        return Math.min(min, max);
    }

    public static int getPokemonCapsuleMaxLevel(boolean shiny) {
        int min = shiny ? shinyPokemonCapsuleMinLevel : pokemonCapsuleMinLevel;
        int max = shiny ? shinyPokemonCapsuleMaxLevel : pokemonCapsuleMaxLevel;
        return Math.max(min, max);
    }

    public static int getCapsuleStackLimit() {
        return capsuleStackSize;
    }

    public static int getCoreStackLimit() {
        return coreStackSize;
    }

    public static class Server {
        private final ModConfigSpec.IntValue pokemonCapsuleMinLevel;
        private final ModConfigSpec.IntValue pokemonCapsuleMaxLevel;
        private final ModConfigSpec.IntValue shinyPokemonCapsuleMinLevel;
        private final ModConfigSpec.IntValue shinyPokemonCapsuleMaxLevel;
        private final ModConfigSpec.IntValue capsuleStackSize;
        private final ModConfigSpec.IntValue coreStackSize;

        Server(ModConfigSpec.Builder builder) {
            builder.push("pokemon_capsules");
            this.pokemonCapsuleMinLevel = builder.comment("Minimum level for Pok\u00e9mon spawned by standard Pok\u00e9mon Capsules.").defineInRange("pokemon_capsule_min_level", 1, 1, 100);
            this.pokemonCapsuleMaxLevel = builder.comment("Maximum level for Pok\u00e9mon spawned by standard Pok\u00e9mon Capsules.").defineInRange("pokemon_capsule_max_level", 100, 1, 100);
            this.shinyPokemonCapsuleMinLevel = builder.comment("Minimum level for Pok\u00e9mon spawned by Shiny Pok\u00e9mon Capsules.").defineInRange("pokemon_capsule_shiny_min_level", 1, 1, 100);
            this.shinyPokemonCapsuleMaxLevel = builder.comment("Maximum level for Pok\u00e9mon spawned by Shiny Pok\u00e9mon Capsules.").defineInRange("pokemon_capsule_shiny_max_level", 100, 1, 100);
            builder.pop();
            builder.push("stack_limits");
            this.capsuleStackSize = builder.comment("Maximum stack size for all capsule items.").defineInRange("capsule_stack_size", 16, 1, 64);
            this.coreStackSize = builder.comment("Maximum stack size for all core items.").defineInRange("core_stack_size", 16, 1, 64);
            builder.pop();
        }
    }
}

