/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.cobblecapsule;

import com.mojang.logging.LogUtils;
import net.levelscraft7.cobblecapsule.Config;
import net.levelscraft7.cobblecapsule.WorldGenConfigGenerator;
import net.levelscraft7.cobblecapsule.block.ModBlocks;
import net.levelscraft7.cobblecapsule.block.entity.ModBlockEntities;
import net.levelscraft7.cobblecapsule.item.ModCreativeModeTabs;
import net.levelscraft7.cobblecapsule.item.ModItems;
import net.levelscraft7.cobblecapsule.menu.ModMenuTypes;
import net.levelscraft7.cobblecapsule.recipe.ModRecipes;
import net.levelscraft7.cobblecapsule.util.CapsuleLootManager;
import net.levelscraft7.cobblecapsule.util.PokemonCapsuleRegistry;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="cobblecapsule")
public class CobbleCapsule {
    public static final String MOD_ID = "cobblecapsule";
    public static final Logger LOGGER = LogUtils.getLogger();

    public CobbleCapsule(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(Config::onConfigEvent);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.addListener(this::addReloadListeners);
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(WorldGenConfigGenerator::ensureWorldGenConfig);
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)CapsuleLootManager.INSTANCE);
        event.addListener((PreparableReloadListener)PokemonCapsuleRegistry.INSTANCE);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(ModItems.CORELITE_SHARD);
            event.accept(ModItems.CORELITE_CRYSTAL);
            event.accept(ModItems.CORELITE_INGOT);
            event.accept(ModBlocks.CORELITE_BLOCK);
            event.accept(ModItems.INFUSED_COAL);
            event.accept(ModBlocks.CORELITE_ORE);
            event.accept(ModBlocks.CORELITE_NETHER_ORE);
            event.accept(ModBlocks.CORELITE_END_ORE);
            event.accept(ModBlocks.CORELITE_DEEPSLATE_ORE);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ModItems.CORELINK_ACTIVATOR);
            event.accept(ModItems.COMBAT_CAPSULE_BASIC);
            event.accept(ModItems.COMBAT_CAPSULE_RARE);
            event.accept(ModItems.COMBAT_CAPSULE_EPIC);
            event.accept(ModItems.RESOURCE_CAPSULE_BASIC);
            event.accept(ModItems.RESOURCE_CAPSULE_RARE);
            event.accept(ModItems.RESOURCE_CAPSULE_EPIC);
            event.accept(ModItems.HEALING_CAPSULE_BASIC);
            event.accept(ModItems.HEALING_CAPSULE_RARE);
            event.accept(ModItems.HEALING_CAPSULE_EPIC);
            event.accept(ModItems.POKEMON_CAPSULE);
            event.accept(ModItems.POKEMON_CAPSULE_SHINY);
        }
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept(ModBlocks.CORE_TABLE);
            event.accept(ModBlocks.DISPLAY_CASE);
            event.accept(ModItems.CAPSULE_CORE_BASIC);
            event.accept(ModItems.CAPSULE_CORE_RARE);
            event.accept(ModItems.CAPSULE_CORE_EPIC);
            event.accept(ModItems.POKEMON_CORE);
            event.accept(ModItems.HEALING_CORE);
            event.accept(ModItems.RESOURCE_CORE);
            event.accept(ModItems.COMBAT_CORE);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }
}

