/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import io.github.kosmx.emotes.arch.ClientCommands;
import io.github.kosmx.emotes.arch.ServerCommands;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.MainLoader;
import io.github.kosmx.emotes.neoforge.ClientInit;
import io.github.kosmx.emotes.neoforge.executor.ForgeEmotesMain;
import java.util.logging.Level;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="emotecraft")
public class ForgeWrapper {
    public static final Logger logger = LoggerFactory.getLogger((String)"emotecraft");

    public ForgeWrapper(ModContainer container, IEventBus modEventBus) {
        EmoteInstance.instance = new ForgeEmotesMain();
        MainLoader.main(null);
        NeoForge.EVENT_BUS.register((Object)this);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ClientInit.initClient(container, modEventBus);
        }
    }

    @SubscribeEvent
    public void commandRegister(RegisterCommandsEvent event) {
        ServerCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    @SubscribeEvent
    public void clientCommandRegister(RegisterClientCommandsEvent event) {
        ClientCommands.register(event.getDispatcher(), event.getBuildContext());
    }

    public static void log(Level level, String msg) {
        if (level.intValue() <= Level.INFO.intValue()) {
            logger.debug(msg);
        } else if (level.intValue() <= Level.WARNING.intValue()) {
            logger.warn(msg);
        } else {
            logger.error(msg);
        }
    }

    public static void log(Level level, String msg, Throwable t) {
        if (level.intValue() <= Level.INFO.intValue()) {
            logger.debug(msg, t);
        } else if (level.intValue() <= Level.WARNING.intValue()) {
            logger.warn(msg, t);
        } else {
            logger.error(msg, t);
        }
    }
}

