/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.arch.executor.ClientMethods;
import io.github.kosmx.emotes.arch.network.client.ClientNetwork;
import io.github.kosmx.emotes.arch.screen.EmoteMenu;
import io.github.kosmx.emotes.arch.screen.ingame.FastMenuScreen;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.MainClientInit;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.Connection;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientInit {
    static KeyMapping openMenuKey;
    static KeyMapping stopEmote;
    static KeyMapping debugKey;
    static Consumer<Minecraft> keyBindingFunction;

    static void initClient(ModContainer container, IEventBus modEventBus) {
        ClientInit.initKeyBinding();
        modEventBus.addListener(ClientInit::keyBindingRegister);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(minecraft, screen) -> new EmoteMenu(screen)));
    }

    @SubscribeEvent
    public static void endClientTick(ClientTickEvent.Post event) {
        ++ClientMethods.tick;
    }

    @SubscribeEvent
    public static void keyListenerEvent(InputEvent.Key event) {
        keyBindingFunction.accept(null);
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientNetwork.INSTANCE.disconnect();
    }

    @SubscribeEvent
    public static void onConnect(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientNetwork.INSTANCE.configureOnPlay(arg_0 -> ((Connection)event.getConnection()).send(arg_0));
    }

    public static void keyBindingRegister(RegisterKeyMappingsEvent event) {
        event.register(openMenuKey);
        event.register(stopEmote);
        if (debugKey != null) {
            event.register(debugKey);
        }
    }

    private static void initKeyBinding() {
        openMenuKey = new KeyMapping("key.emotecraft.fastchoose", InputConstants.Type.KEYSYM, 66, "category.emotecraft.keybinding");
        stopEmote = new KeyMapping("key.emotecraft.stop", InputConstants.Type.KEYSYM, -1, "category.emotecraft.keybinding");
        if (FMLLoader.getGamePath().resolve("emote.json").toFile().isFile()) {
            debugKey = new KeyMapping("key.emotecraft.debug", InputConstants.Type.KEYSYM, 79, "category.emotecraft.keybinding");
        }
        keyBindingFunction = client -> {
            if (openMenuKey.consumeClick() && (((ClientConfig)EmoteInstance.config).alwaysOpenEmoteScreen.get().booleanValue() || Minecraft.getInstance().player == Minecraft.getInstance().getCameraEntity())) {
                Minecraft.getInstance().setScreen((Screen)new FastMenuScreen(null));
            }
            if (stopEmote.consumeClick()) {
                ClientEmotePlay.clientStopLocalEmote();
            }
            if (debugKey != null && debugKey.consumeClick()) {
                MainClientInit.playDebugEmote();
            }
        };
    }

    static {
        debugKey = null;
    }
}

