/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kosmx.playerAnim.core.util.MathHelper;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseWheel;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModernChooseWheel
implements IChooseWheel {
    public static int fastMenuPage = 0;
    protected final ArrayList<FastChooseElement> elements = new ArrayList();
    private boolean hovered;
    private final ResourceLocation TEXTURE;
    private final AbstractFastChooseWidget widget;

    public ModernChooseWheel(AbstractFastChooseWidget widget) {
        this.TEXTURE = ((ClientConfig)EmoteInstance.config).dark.get() != false ? PlatformTools.newIdentifier("textures/gui/fastchoose_dark_new.png") : PlatformTools.newIdentifier("textures/gui/fastchoose_light_new.png");
        this.widget = widget;
        this.elements.add(new FastChooseElement(0, 0.0f));
        this.elements.add(new FastChooseElement(1, 45.0f));
        this.elements.add(new FastChooseElement(2, 90.0f));
        this.elements.add(new FastChooseElement(3, 135.0f));
        this.elements.add(new FastChooseElement(4, 180.0f));
        this.elements.add(new FastChooseElement(5, 225.0f));
        this.elements.add(new FastChooseElement(6, 270.0f));
        this.elements.add(new FastChooseElement(7, 315.0f));
    }

    @Nullable
    protected FastChooseElement getActivePart(int mouseX, int mouseY) {
        int x = mouseX - this.widget.getX() - this.widget.getWidth() / 2;
        int y = mouseY - this.widget.getY() - this.widget.getHeight() / 2;
        int i = 0;
        double pi = Math.PI;
        double distanceFromCenter = Math.sqrt(x * x + y * y);
        if (distanceFromCenter < (double)this.widget.getWidth() * 0.17 || distanceFromCenter > (double)this.widget.getWidth() / 2.0) {
            return null;
        }
        float degrees = (float)(Math.abs((Math.atan2(y, x) - pi) / (2.0 * pi) * 360.0 - 270.0) % 360.0);
        if ((double)degrees < 22.5) {
            i = 0;
        } else if ((double)degrees < 67.5) {
            i = 1;
        } else if ((double)degrees < 112.5) {
            i = 2;
        } else if ((double)degrees < 157.5) {
            i = 3;
        } else if ((double)degrees < 202.5) {
            i = 4;
        } else if ((double)degrees < 247.5) {
            i = 5;
        } else if ((double)degrees < 292.5) {
            i = 6;
        } else if ((double)degrees < 337.5) {
            i = 7;
        }
        return this.elements.get(i);
    }

    private int getPageButton(int mouseX, int mouseY) {
        int y;
        int x = mouseX - this.widget.getX() - this.widget.getWidth() / 2;
        double distanceFromCenter = Math.sqrt(x * x + (y = mouseY - this.widget.getY() - this.widget.getHeight() / 2) * y);
        if (distanceFromCenter < (double)this.widget.getWidth() * 0.17 || distanceFromCenter > (double)this.widget.getWidth() / 2.0) {
            if (x > 1) {
                return 1;
            }
            if (x < 1) {
                return 0;
            }
        }
        return -1;
    }

    public void render(@NotNull GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        Object part;
        this.checkHovered(mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.drawTexture(matrices, this.TEXTURE, 0, 0, 0, 0, 2);
        if (this.hovered && (part = this.getActivePart(mouseX, mouseY)) != null && this.widget.doHoverPart((IChooseWheel.IChooseElement)part)) {
            ((FastChooseElement)part).renderHover(matrices, this.TEXTURE);
        }
        for (FastChooseElement f : this.elements) {
            if (!f.hasEmote()) continue;
            f.render(matrices);
        }
        MutableComponent text = Component.literal((String)String.valueOf(fastMenuPage + 1));
        matrices.drawString(Minecraft.getInstance().font, (Component)text, (int)((float)this.widget.getX() + (float)this.widget.getWidth() / 2.0f - 2.0f), (int)((float)this.widget.getY() + (float)this.widget.getHeight() / 2.0f - 3.0f), -1);
    }

    private void drawTexture(GuiGraphics matrices, ResourceLocation t, int x, int y, int u, int v, int s) {
        matrices.blit(t, this.widget.getX() + x * this.widget.getWidth() / 256, this.widget.getY() + y * this.widget.getHeight() / 256, s * this.widget.getWidth() / 2, s * this.widget.getHeight() / 2, (float)u, (float)v, s * 128, s * 128, 512, 512);
    }

    private void drawTexture_select(GuiGraphics matrices, ResourceLocation t, int x, int y, int u, int v, int w, int h) {
        matrices.blit(t, this.widget.getX() + x * this.widget.getWidth() / 512, this.widget.getY() + y * this.widget.getHeight() / 512, w * this.widget.getWidth() / 2, h * this.widget.getHeight() / 2, (float)u, (float)v, w * 128, h * 128, 512, 512);
    }

    private void checkHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.widget.getX() && mouseY >= this.widget.getY() && mouseX <= this.widget.getX() + this.widget.getWidth() && mouseY <= this.widget.getY() + this.widget.getHeight();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.checkHovered((int)mouseX, (int)mouseY);
        if (this.hovered && this.widget.isValidClickButton(button)) {
            FastChooseElement element = this.getActivePart((int)mouseX, (int)mouseY);
            if (element != null) {
                return this.widget.onClick(element, button);
            }
            int selectedPageButton = this.getPageButton((int)mouseX, (int)mouseY);
            if (selectedPageButton == 0) {
                fastMenuPage = fastMenuPage > 0 ? --fastMenuPage : 9;
            } else if (selectedPageButton == 1) {
                fastMenuPage = fastMenuPage < 9 ? ++fastMenuPage : 0;
            }
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.checkHovered((int)mouseX, (int)mouseY);
        if (verticalAmount < 0.0) {
            if (fastMenuPage < 9) {
                ++fastMenuPage;
                return true;
            }
        } else if (fastMenuPage > 0) {
            --fastMenuPage;
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        this.checkHovered((int)mouseX, (int)mouseY);
        return this.hovered;
    }

    protected class FastChooseElement
    implements IChooseWheel.IChooseElement {
        private final float angle;
        private final int id;

        protected FastChooseElement(int num, float angle) {
            this.angle = angle;
            this.id = num;
        }

        @Override
        public boolean hasEmote() {
            return ((ClientConfig)EmoteInstance.config).fastMenuEmotes[fastMenuPage][this.id] != null;
        }

        @Override
        public void setEmote(@Nullable EmoteHolder emote) {
            ((ClientConfig)EmoteInstance.config).fastMenuEmotes[ModernChooseWheel.fastMenuPage][this.id] = emote == null ? null : emote.getUuid();
        }

        @Override
        @Nullable
        public EmoteHolder getEmote() {
            UUID uuid = ((ClientConfig)EmoteInstance.config).fastMenuEmotes[fastMenuPage][this.id];
            if (uuid != null) {
                EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get((Object)uuid);
                if (emote == null && ModernChooseWheel.this.widget.doesShowInvalid()) {
                    emote = new EmoteHolder.Empty(uuid);
                }
                return emote;
            }
            return null;
        }

        @Override
        public void clearEmote() {
            this.setEmote(null);
        }

        public void render(GuiGraphics matrices) {
            ResourceLocation identifier;
            UUID emoteID = ((ClientConfig)EmoteInstance.config).fastMenuEmotes[fastMenuPage][this.id] != null ? ((ClientConfig)EmoteInstance.config).fastMenuEmotes[fastMenuPage][this.id] : null;
            ResourceLocation resourceLocation = identifier = emoteID != null && EmoteHolder.list.get(emoteID) != null ? ((EmoteHolder)EmoteHolder.list.get((Object)emoteID)).getIconIdentifier() : null;
            if (identifier != null && ((ClientConfig)EmoteInstance.config).showIcons.get().booleanValue()) {
                int s = ModernChooseWheel.this.widget.getWidth() / 10;
                int iconX = (int)((double)(ModernChooseWheel.this.widget.getX() + ModernChooseWheel.this.widget.getWidth() / 2) + (double)ModernChooseWheel.this.widget.getWidth() * 0.36 * Math.sin((double)this.angle * 0.0174533)) - s;
                int iconY = (int)((double)(ModernChooseWheel.this.widget.getY() + ModernChooseWheel.this.widget.getHeight() / 2) + (double)ModernChooseWheel.this.widget.getHeight() * 0.36 * Math.cos((double)this.angle * 0.0174533)) - s;
                matrices.blit(identifier, iconX, iconY, s * 2, s * 2, 0.0f, 0.0f, 256, 256, 256, 256);
            } else if (((ClientConfig)EmoteInstance.config).fastMenuEmotes[fastMenuPage][this.id] != null) {
                this.drawCenteredText(matrices, EmoteHolder.getNonNull((UUID)((ClientConfig)EmoteInstance.config).fastMenuEmotes[ModernChooseWheel.fastMenuPage][this.id]).name, this.angle);
            } else {
                EmoteInstance.instance.getLogger().log(Level.WARNING, "Tried to render non-existing name", true);
            }
        }

        public void drawCenteredText(GuiGraphics matrixStack, Component stringRenderable, float deg) {
            this.drawCenteredText(matrixStack, stringRenderable, (float)((double)(ModernChooseWheel.this.widget.getX() + ModernChooseWheel.this.widget.getWidth() / 2) + (double)ModernChooseWheel.this.widget.getWidth() * 0.4 * Math.sin((double)deg * 0.0174533)), (float)((double)(ModernChooseWheel.this.widget.getY() + ModernChooseWheel.this.widget.getHeight() / 2) + (double)ModernChooseWheel.this.widget.getHeight() * 0.4 * Math.cos((double)deg * 0.0174533)));
        }

        public void drawCenteredText(GuiGraphics matrices, Component stringRenderable, float x, float y) {
            int c = ((ClientConfig)EmoteInstance.config).dark.get() != false ? 255 : 0;
            float x1 = x - (float)Minecraft.getInstance().font.width((FormattedText)stringRenderable) / 2.0f;
            matrices.drawString(Minecraft.getInstance().font, stringRenderable, (int)x1, (int)(y - 2.0f), MathHelper.colorHelper((int)c, (int)c, (int)c, (int)1));
        }

        public void renderHover(GuiGraphics matrices, ResourceLocation t) {
            switch (this.id) {
                case 0: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 256, 0, 384, 2, 1);
                    break;
                }
                case 1: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 256, 256, 384, 384, 1, 1);
                    break;
                }
                case 2: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 256, 0, 384, 0, 1, 2);
                    break;
                }
                case 3: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 256, 0, 384, 256, 1, 1);
                    break;
                }
                case 4: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 0, 0, 256, 2, 1);
                    break;
                }
                case 5: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 0, 256, 256, 1, 1);
                    break;
                }
                case 6: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 0, 256, 0, 1, 2);
                    break;
                }
                case 7: {
                    ModernChooseWheel.this.drawTexture_select(matrices, t, 0, 256, 256, 384, 1, 1);
                }
            }
        }
    }
}

