/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network.client;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.arch.network.client.neoforge.ClientNetworkImpl;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.EmoteStreamHelper;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.inline.TmpGetters;
import io.github.kosmx.emotes.main.EmoteHolder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClientNetwork
extends AbstractNetworkInstance {
    public static ClientNetwork INSTANCE = new ClientNetwork();
    @NotNull
    private final EmoteStreamHelper streamHelper = new EmoteStreamHelper(){

        @Override
        protected int getMaxPacketSize() {
            return ClientNetwork.this.maxDataSize();
        }

        @Override
        protected void sendPlayPacket(ByteBuffer buffer) {
            ClientNetwork.sendPlayPacket(ClientNetwork.playPacket(buffer));
        }

        @Override
        protected void sendStreamChunk(ByteBuffer buffer) {
            ClientNetwork.sendPlayPacket(ClientNetwork.streamPacket(buffer));
        }
    };
    private boolean isConfiguredNormally;

    @Override
    public boolean isActive() {
        return ClientNetwork.isServerChannelOpen(NetworkPlatformTools.EMOTE_CHANNEL_ID.id());
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (target != null) {
            builder.configureTarget(target);
        }
        EmotePacket writer = builder.build();
        ByteBuffer bytes = writer.write();
        this.sendMessage(bytes, null);
        if (writer.data.emoteData != null && writer.data.emoteData.extraData.containsKey("song") && !writer.data.writeSong) {
            TmpGetters.getClientMethods().sendChatMessage((Component)Component.translatable((String)"emotecraft.song_too_big_to_send"));
        }
    }

    @Override
    protected void sendMessage(byte[] bytes, @Nullable UUID target) {
        this.sendMessage(ByteBuffer.wrap(bytes), null);
    }

    @Override
    public void sendMessage(ByteBuffer byteBuffer, @Nullable UUID target) {
        ClientNetwork.sendPlayPacket(ClientNetwork.playPacket(byteBuffer));
    }

    @ExpectPlatform
    @Contract
    @ExpectPlatform.Transformed
    public static boolean isServerChannelOpen(ResourceLocation id) {
        return ClientNetworkImpl.isServerChannelOpen(id);
    }

    public static void sendPlayPacket(Packet<?> packet) {
        Objects.requireNonNull(Minecraft.getInstance().getConnection()).send(packet);
    }

    public void receiveStreamMessage(@NotNull ByteBuffer buff, @Nullable Consumer<Packet<?>> configPacketConsumer) throws IOException {
        @Nullable ByteBuffer buffer = this.streamHelper.receiveStream(buff);
        if (buffer != null) {
            if (configPacketConsumer != null) {
                this.receiveConfigMessage(buffer, configPacketConsumer);
            } else {
                this.receiveMessage(buffer, null);
            }
        }
    }

    public void receiveConfigMessage(@NotNull ByteBuffer buf, @NotNull Consumer<Packet<?>> consumer) throws IOException {
        NetData packet = new EmotePacket.Builder().build().read(buf);
        if (packet != null) {
            if (packet.purpose == PacketTask.CONFIG) {
                this.setVersions(packet.versions);
                this.sendC2SConfig(p -> {
                    try {
                        consumer.accept(ClientNetwork.playPacket(p.build().write()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.isConfiguredNormally = true;
            } else if (packet.purpose == PacketTask.FILE) {
                EmoteHolder.addEmoteToList((KeyframeAnimation)packet.emoteData).fromInstance = this;
            } else if (EmoteInstance.config.showDebug.get().booleanValue()) {
                EmoteInstance.instance.getLogger().log(Level.INFO, "Invalid emotes packet type in configuration phase: " + String.valueOf((Object)packet.purpose));
            }
        } else {
            throw new IOException("Invalid emotes packet received in config phase");
        }
    }

    @Deprecated
    public void configureOnPlay(@NotNull Consumer<Packet<?>> consumer) {
        if (!this.isConfiguredNormally && this.isActive()) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, "The server failed to configure the client, attempting to configure...");
            this.sendC2SConfig(p -> {
                try {
                    consumer.accept(ClientNetwork.playPacket(p.build().write()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.isConfiguredNormally = false;
    }

    @Override
    public int maxDataSize() {
        return 32751;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static Packet<?> createServerboundPacket(@NotNull CustomPacketPayload.Type<EmotePacketPayload> id, @NotNull ByteBuffer buf) {
        void var1_1;
        return ClientNetworkImpl.createServerboundPacket(id, (ByteBuffer)var1_1);
    }

    @NotNull
    public static Packet<?> playPacket(@NotNull ByteBuffer buf) {
        return ClientNetwork.createServerboundPacket(NetworkPlatformTools.EMOTE_CHANNEL_ID, buf);
    }

    @NotNull
    public static Packet<?> streamPacket(@NotNull ByteBuffer buf) {
        return ClientNetwork.createServerboundPacket(NetworkPlatformTools.STREAM_CHANNEL_ID, buf);
    }
}

