/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.network.ConfigurationTask;
import org.jetbrains.annotations.NotNull;

public class ConfigTask
implements ConfigurationTask {
    public static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type("emotes:config");

    public void start(@NotNull Consumer<Packet<?>> consumer) {
        NetData configData = new EmotePacket.Builder().configureToConfigExchange((boolean)true).build().data;
        configData.versions.put((byte)-128, (byte)1);
        try {
            ByteBuffer bytes = new EmotePacket.Builder(configData).build().write();
            consumer.accept(NetworkPlatformTools.playPacket(bytes));
        }
        catch (IOException e) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @NotNull
    public ConfigurationTask.Type type() {
        return TYPE;
    }
}

