/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.IPlayer;
import dev.kosmx.playerAnim.api.layered.AnimationContainer;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.opennbs.format.Layer;
import dev.kosmx.playerAnim.core.util.Vec3d;
import io.github.kosmx.emotes.arch.emote.EmotePlayImpl;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import io.github.kosmx.emotes.main.mixinFunctions.IPlayerEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractClientPlayer.class})
public abstract class EmotePlayerMixin
extends Player
implements IPlayerEntity {
    @Unique
    private int emotes_age = 0;
    @Shadow
    @Final
    public ClientLevel clientLevel;
    @Unique
    private AnimationContainer<EmotePlayer> emotecraftEmoteContainer = new AnimationContainer(null);
    @Unique
    private boolean isForced = false;

    public EmotePlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/multiplayer/ClientLevel;Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void init(ClientLevel clientLevel, GameProfile gameProfile, CallbackInfo ci) {
        ((IPlayer)this).getAnimationStack().addAnimLayer(1000, this.emotecraftEmoteContainer);
    }

    @Override
    public void emotecraft$playEmote(KeyframeAnimation emote, int t, boolean isForced) {
        this.emotecraftEmoteContainer.setAnim((IAnimation)new EmotePlayImpl(emote, this::emotecraft$noteConsumer, t));
        this.initEmotePerspective((EmotePlayer)this.emotecraftEmoteContainer.getAnim());
        if (this.isMainPlayer()) {
            this.isForced = isForced;
        }
    }

    @Unique
    private void emotecraft$noteConsumer(Layer.Note note) {
        this.clientLevel.playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)EmotePlayerMixin.getInstrumentFromCode(note.instrument).getSoundEvent().value(), SoundSource.PLAYERS, note.getVolume(), note.getPitch(), true);
    }

    @Unique
    private static NoteBlockInstrument getInstrumentFromCode(byte b) {
        NoteBlockInstrument[] instruments = new NoteBlockInstrument[]{NoteBlockInstrument.HARP, NoteBlockInstrument.BASS, NoteBlockInstrument.BASEDRUM, NoteBlockInstrument.SNARE, NoteBlockInstrument.HAT, NoteBlockInstrument.GUITAR, NoteBlockInstrument.FLUTE, NoteBlockInstrument.BELL, NoteBlockInstrument.CHIME, NoteBlockInstrument.XYLOPHONE, NoteBlockInstrument.IRON_XYLOPHONE, NoteBlockInstrument.COW_BELL, NoteBlockInstrument.DIDGERIDOO, NoteBlockInstrument.BIT, NoteBlockInstrument.BANJO, NoteBlockInstrument.PLING};
        if (b >= 0 && b < instruments.length) {
            return instruments[b];
        }
        return NoteBlockInstrument.HARP;
    }

    @Override
    public int emotes_getAge() {
        return this.emotes_age;
    }

    @Override
    public int emotes_getAndIncreaseAge() {
        return this.emotes_age++;
    }

    @Override
    public void emotecraft$voidEmote() {
        this.emotecraftEmoteContainer.setAnim(null);
    }

    @Override
    @Nullable
    public EmotePlayer emotecraft$getEmote() {
        return (EmotePlayer)this.emotecraftEmoteContainer.getAnim();
    }

    @Override
    public UUID emotes_getUUID() {
        return this.getUUID();
    }

    @Override
    public boolean emotecraft$isNotStanding() {
        return this.getPose() != Pose.STANDING;
    }

    @Override
    public Vec3d emotecraft$emotesGetPos() {
        return new Vec3d(Double.valueOf(this.getX()), Double.valueOf(this.getY()), Double.valueOf(this.getZ()));
    }

    @Override
    public Vec3d emotecraft$getPrevPos() {
        return new Vec3d(Double.valueOf(this.xo), Double.valueOf(this.yo), Double.valueOf(this.zo));
    }

    @Override
    public float emotecraft$getBodyYaw() {
        return this.yBodyRot;
    }

    @Override
    public float emotecraft$getViewYaw() {
        return this.yHeadRot;
    }

    @Override
    public void emotecraft$setBodyYaw(float newYaw) {
        this.yBodyRot = newYaw;
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.emoteTick();
    }

    @Override
    public boolean emotecraft$isForcedEmote() {
        return this.isPlayingEmote() && this.isForced;
    }
}

