/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.counter.item;

import com.cobblemon.mod.common.client.tooltips.TooltipGenerator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.counter.CounterMod;
import us.timinc.mc.cobblemon.counter.api.ClientCounterManager;
import us.timinc.mc.cobblemon.counter.api.CounterType;
import us.timinc.mc.cobblemon.counter.api.CounterTypeRegistry;
import us.timinc.mc.cobblemon.counter.api.Streak;
import us.timinc.mc.cobblemon.counter.item.CounterItem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\n\u00a8\u0006\f"}, d2={"Lus/timinc/mc/cobblemon/counter/item/CounterTooltipGenerator;", "Lcom/cobblemon/mod/common/client/tooltips/TooltipGenerator;", "<init>", "()V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "Lnet/minecraft/network/chat/Component;", "lines", "generateTooltip", "(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;)Ljava/util/List;", "generateAdditionalTooltip", "common"})
@SourceDebugExtension(value={"SMAP\nCounterTooltipGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CounterTooltipGenerator.kt\nus/timinc/mc/cobblemon/counter/item/CounterTooltipGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1869#2,2:76\n*S KotlinDebug\n*F\n+ 1 CounterTooltipGenerator.kt\nus/timinc/mc/cobblemon/counter/item/CounterTooltipGenerator\n*L\n21#1:76,2\n*E\n"})
public final class CounterTooltipGenerator
extends TooltipGenerator {
    @NotNull
    public static final CounterTooltipGenerator INSTANCE = new CounterTooltipGenerator();

    private CounterTooltipGenerator() {
    }

    @NotNull
    public List<Component> generateTooltip(@NotNull ItemStack stack, @NotNull List<Component> lines) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        List resultLines = new ArrayList();
        if (!stack.is(CounterMod.Items.INSTANCE.getCOUNTER().getItem())) {
            return resultLines;
        }
        try {
            String mode = CounterItem.Companion.getCLIENT_SPECIES() == null ? "streak" : "count";
            MutableComponent mutableComponent = Component.translatable((String)("cobbled_counter.item.counter.tooltip." + mode));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            resultLines.add(mutableComponent);
            Iterable $this$forEach$iv = CounterTypeRegistry.INSTANCE.counterTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                CounterType it = (CounterType)element$iv;
                boolean bl = false;
                int count = 0;
                ResourceLocation species = null;
                String form = null;
                if (Intrinsics.areEqual((Object)mode, (Object)"streak")) {
                    Streak streak = ClientCounterManager.Companion.getClientCounterData().getStreak(it);
                    count = streak.getCount();
                    species = streak.getSpecies();
                    form = streak.getForm();
                    if (count == 0) {
                        MutableComponent mutableComponent2 = Component.translatable((String)("cobbled_counter.item.counter.tooltip." + it.getType() + ".no_streak"));
                        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
                        resultLines.add(mutableComponent2);
                        continue;
                    }
                } else {
                    count = ClientCounterManager.Companion.getClientCounterData().getCountScore(it, CounterItem.Companion.getCLIENT_SPECIES(), CounterItem.Companion.getCLIENT_FORM());
                    ResourceLocation resourceLocation = CounterItem.Companion.getCLIENT_SPECIES();
                    if (resourceLocation == null) continue;
                    species = resourceLocation;
                    String string2 = CounterItem.Companion.getCLIENT_FORM();
                    if (string2 == null) continue;
                    form = string2;
                }
                String string3 = "cobbled_counter.item.counter.tooltip." + it.getType() + "." + mode;
                Object[] objectArray = new Object[3];
                objectArray[0] = count;
                objectArray[1] = Component.translatable((String)("cobblemon.species." + species.getPath() + ".name"));
                if (Intrinsics.areEqual((Object)form, (Object)"Normal")) {
                    string = "";
                } else {
                    Object[] objectArray2 = new Object[]{form};
                    string = Component.translatable((String)"cobbled_counter.item.counter.tooltip.form", (Object[])objectArray2);
                }
                objectArray[2] = string;
                MutableComponent mutableComponent3 = Component.translatable((String)string3, (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
                resultLines.add(mutableComponent3);
            }
            return resultLines;
        }
        catch (Error e) {
            return resultLines;
        }
    }

    @NotNull
    public List<Component> generateAdditionalTooltip(@NotNull ItemStack stack, @NotNull List<Component> lines) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        List resultLines = new ArrayList();
        if (!stack.is(CounterMod.Items.INSTANCE.getCOUNTER().getItem())) {
            return resultLines;
        }
        String otherMode = CounterItem.Companion.getCLIENT_SPECIES() == null ? "count" : "streak";
        MutableComponent mutableComponent = Component.translatable((String)("cobbled_counter.item.counter.tooltip.switch_mode_info.to_" + otherMode));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        resultLines.add(mutableComponent);
        return resultLines;
    }
}

