/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.counter.api;

import com.cobblemon.mod.common.util.BufferUtilsKt;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.counter.CounterMod;
import us.timinc.mc.cobblemon.counter.api.Streak;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB3\u0012 \b\u0002\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0012\u0010\u0011R/\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lus/timinc/mc/cobblemon/counter/api/Counter;", "", "", "Lnet/minecraft/resources/ResourceLocation;", "", "", "count", "Lus/timinc/mc/cobblemon/counter/api/Streak;", "streak", "<init>", "(Ljava/util/Map;Lus/timinc/mc/cobblemon/counter/api/Streak;)V", "clone", "()Lus/timinc/mc/cobblemon/counter/api/Counter;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "buf", "", "encode", "(Lnet/minecraft/network/RegistryFriendlyByteBuf;)V", "decode", "Ljava/util/Map;", "getCount", "()Ljava/util/Map;", "Lus/timinc/mc/cobblemon/counter/api/Streak;", "getStreak", "()Lus/timinc/mc/cobblemon/counter/api/Streak;", "setStreak", "(Lus/timinc/mc/cobblemon/counter/api/Streak;)V", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Counter.kt\nus/timinc/mc/cobblemon/counter/api/Counter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,73:1\n216#2,2:74\n*S KotlinDebug\n*F\n+ 1 Counter.kt\nus/timinc/mc/cobblemon/counter/api/Counter\n*L\n24#1:74,2\n*E\n"})
public final class Counter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ResourceLocation, Map<String, Integer>> count;
    @NotNull
    private Streak streak;
    @NotNull
    private static final Codec<Counter> CODEC;

    public Counter(@NotNull Map<ResourceLocation, Map<String, Integer>> count, @NotNull Streak streak) {
        Intrinsics.checkNotNullParameter(count, (String)"count");
        Intrinsics.checkNotNullParameter((Object)streak, (String)"streak");
        this.count = count;
        this.streak = streak;
    }

    public /* synthetic */ Counter(Map map, Streak streak, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 2) != 0) {
            streak = new Streak(null, null, 0, 7, null);
        }
        this(map, streak);
    }

    @NotNull
    public final Map<ResourceLocation, Map<String, Integer>> getCount() {
        return this.count;
    }

    @NotNull
    public final Streak getStreak() {
        return this.streak;
    }

    public final void setStreak(@NotNull Streak streak) {
        Intrinsics.checkNotNullParameter((Object)streak, (String)"<set-?>");
        this.streak = streak;
    }

    @NotNull
    public final Counter clone() {
        return new Counter(MapsKt.toMutableMap(this.count), this.streak.clone());
    }

    public final void encode(@NotNull RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        ByteBuf byteBuf = (ByteBuf)buf;
        String string = this.streak.getSpecies().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        BufferUtilsKt.writeString((ByteBuf)byteBuf, (String)string);
        BufferUtilsKt.writeString((ByteBuf)((ByteBuf)buf), (String)this.streak.getForm());
        buf.writeInt(this.streak.getCount());
        buf.writeInt(this.count.size());
        for (Map.Entry<ResourceLocation, Map<String, Integer>> entry : this.count.entrySet()) {
            ResourceLocation resourceLocation = entry.getKey();
            Map<String, Integer> speciesRecord = entry.getValue();
            ByteBuf byteBuf2 = (ByteBuf)buf;
            String string2 = resourceLocation.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            BufferUtilsKt.writeString((ByteBuf)byteBuf2, (String)string2);
            buf.writeInt(speciesRecord.size());
            for (Map.Entry<String, Integer> entry2 : speciesRecord.entrySet()) {
                String formName = entry2.getKey();
                int count = ((Number)entry2.getValue()).intValue();
                BufferUtilsKt.writeString((ByteBuf)((ByteBuf)buf), (String)formName);
                buf.writeInt(count);
            }
        }
    }

    public final void decode(@NotNull RegistryFriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.streak.setSpecies(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace((String)BufferUtilsKt.readString((ByteBuf)((ByteBuf)buf)), (String)CounterMod.INSTANCE.getModId()));
        this.streak.setForm(BufferUtilsKt.readString((ByteBuf)((ByteBuf)buf)));
        this.streak.setCount(buf.readInt());
        this.count.clear();
        int countSize = buf.readInt();
        for (int i = 0; i < countSize; ++i) {
            ResourceLocation speciesId = ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace((String)BufferUtilsKt.readString((ByteBuf)((ByteBuf)buf)), (String)CounterMod.INSTANCE.getModId());
            Map speciesRecord = new LinkedHashMap();
            int speciesRecordSize = buf.readInt();
            for (int j = 0; j < speciesRecordSize; ++j) {
                String formName = BufferUtilsKt.readString((ByteBuf)((ByteBuf)buf));
                int count = buf.readInt();
                speciesRecord.put(formName, count);
            }
            this.count.put(speciesId, speciesRecord);
        }
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)((Codec)Codec.unboundedMap((Codec)((Codec)PrimitiveCodec.STRING), (Codec)((Codec)PrimitiveCodec.INT)))).fieldOf("count").forGetter(Counter::CODEC$lambda$0$0), (App)Streak.Companion.getCODEC().fieldOf("streak").forGetter(Counter::CODEC$lambda$0$1)).apply((Applicative)instance, Counter::CODEC$lambda$0$2);
    }

    private static final Map CODEC$lambda$0$0(Counter it) {
        return it.count;
    }

    private static final Streak CODEC$lambda$0$1(Counter it) {
        return it.streak;
    }

    private static final Counter CODEC$lambda$0$2(Map count, Streak streak) {
        Map clonedCount = new LinkedHashMap();
        Intrinsics.checkNotNull((Object)count);
        Map $this$forEach$iv = count;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ResourceLocation speciesId = (ResourceLocation)entry.getKey();
            Map speciesRecord = (Map)entry.getValue();
            Intrinsics.checkNotNull((Object)speciesRecord);
            clonedCount.put(speciesId, MapsKt.toMutableMap((Map)speciesRecord));
        }
        Intrinsics.checkNotNull((Object)streak);
        return new Counter(clonedCount, streak);
    }

    public Counter() {
        this(null, null, 3, null);
    }

    static {
        Codec codec = RecordCodecBuilder.create(Counter::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lus/timinc/mc/cobblemon/counter/api/Counter$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lus/timinc/mc/cobblemon/counter/api/Counter;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<Counter> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

