/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.config;

import it.crystalnest.cobweb.api.config.CobwebConfig;
import it.crystalnest.cobweb.api.config.ConfigType;
import it.crystalnest.cobweb.platform.Services;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public abstract class ServerConfig
extends CobwebConfig {
    protected ServerConfig(ModConfigSpec.Builder builder) {
        super(builder);
    }

    protected static <T extends ServerConfig> T register(String modId, Function<ModConfigSpec.Builder, T> constructor) {
        ServerConfig.register(modId, ConfigType.SERVER, constructor);
        if (Services.CONFIG == null) {
            throw new NullPointerException("Make sure you are on NeoForge or the mod Forge Config API Port is installed!");
        }
        Services.CONFIG.registerServerConfig(ServerConfig.getId(modId, ConfigType.SERVER), ServerConfig.getSpec(modId));
        return ServerConfig.getConfig(modId);
    }

    @Nullable
    protected static <T extends ServerConfig> T getConfig(String modId) {
        return (T)((ServerConfig)ServerConfig.getConfig(modId, ConfigType.SERVER));
    }

    @Nullable
    protected static ModConfigSpec getSpec(String modId) {
        return ServerConfig.getSpec(modId, ConfigType.SERVER);
    }
}

