/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.util;

import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class MultiVersionUtil {
    public static ResourceLocation parse(String location) {
        return ResourceLocation.parse((String)location);
    }

    public static ResourceLocation withDefaultNamespace(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static ResourceLocation withModNamespace(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"accessorify", (String)path);
    }

    public static AttributeModifier.Operation operationAdd() {
        return AttributeModifier.Operation.ADD_VALUE;
    }

    public static void registerAccessory(Item item, Accessory accessory) {
        AccessoriesAPI.registerAccessory((Item)item, (Accessory)accessory);
    }

    public static void noRenderer(Item item) {
        AccessoriesRendererRegistry.registerNoRenderer((Item)item);
    }

    public static boolean isAnotherEquipped(ItemStack stack, SlotReference slot, Item item) {
        return slot.capability().isAnotherEquipped(stack, slot, item);
    }

    public static boolean isAnotherEquipped(ItemStack stack, SlotReference slot, Predicate<ItemStack> predicate) {
        return slot.capability().isAnotherEquipped(stack, slot, predicate);
    }

    public static void putAddAttributeModifier(HashMultimap<String, AttributeModifier> map, String slot, String path) {
        map.put((Object)slot, (Object)new AttributeModifier(MultiVersionUtil.withModNamespace(path), 1.0, MultiVersionUtil.operationAdd()));
    }

    public static NonNullList<ItemStack> getItems(ExpandedSimpleContainer container) {
        return container.getItems();
    }

    public static void sendToServer(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static int color(int a, int r, int g, int b) {
        return FastColor.ARGB32.color((int)a, (int)r, (int)g, (int)b);
    }

    public static int as8BitChannel(float value) {
        return FastColor.as8BitChannel((float)value);
    }

    public static boolean debugScreenShown() {
        return Minecraft.getInstance().gui.getDebugOverlay().showDebugScreen();
    }

    public static boolean hasArmor(SlotReference reference) {
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (ItemStack item : player.getArmorSlots()) {
                if (!item.is(ItemTags.CHEST_ARMOR) && !item.is(ItemTags.LEG_ARMOR)) continue;
                return true;
            }
        }
        return false;
    }

    public static void startRender(GuiGraphics guiGraphics) {
        guiGraphics.flush();
        RenderSystem.enableBlend();
    }

    public static void stopRender(GuiGraphics guiGraphics) {
        guiGraphics.flush();
        RenderSystem.disableBlend();
    }
}

