/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootrmon.common.block.entity;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.block.chest.GildedState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableModel;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.google.auto.service.AutoService;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.SimpleLootrInstance;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.data.LootrInventory;
import noobanidus.mods.lootrmon.common.impl.type.GildedChestType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GildedLootChestBlockEntity
extends RandomizableContainerBlockEntity
implements ILootrBlockEntity {
    private final SimpleLootrInstance lootrInstance = new SimpleLootrInstance(() -> ((GildedLootChestBlockEntity)this).getVisualOpeners(), 27);
    public final GildedState posableState = new GildedState();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            if (!GildedLootChestBlockEntity.this.hasBeenOpened()) {
                GildedLootChestBlockEntity.this.lootrInstance.setHasBeenOpened();
                GildedLootChestBlockEntity.this.markChanged();
            }
            GildedLootChestBlockEntity.playSound(level, pos, state, CobblemonSounds.GILDED_CHEST_OPEN);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            GildedLootChestBlockEntity.playSound(level, pos, state, CobblemonSounds.GILDED_CHEST_CLOSE);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int p_155364_, int p_155365_) {
            GildedLootChestBlockEntity.this.signalOpenCount(level, pos, state, p_155364_, p_155365_);
        }

        protected boolean isOwnContainer(Player player) {
            ChestMenu menu;
            Container container;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ChestMenu && (container = (menu = (ChestMenu)abstractContainerMenu).getContainer()) instanceof LootrInventory) {
                LootrInventory data = (LootrInventory)container;
                return GildedLootChestBlockEntity.this.getInfoUUID().equals(data.getInfo().getInfoUUID());
            }
            return false;
        }
    };
    public static Supplier<BlockEntityType<GildedLootChestBlockEntity>> type;

    public GildedLootChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(type.get(), blockPos, blockState);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.cobblemon.gilded_chest");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.lootrInstance.getItems();
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return null;
    }

    public int getContainerSize() {
        return 27;
    }

    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.lootrInstance.getClientOpeners();
    }

    public boolean isClientOpened() {
        return this.lootrInstance.isClientOpened();
    }

    public void setClientOpened(boolean b) {
        this.lootrInstance.setClientOpened(b);
    }

    public void markChanged() {
        super.setChanged();
        this.markDataChanged();
    }

    @Deprecated
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.CHEST;
    }

    public ILootrType getInfoNewType() {
        return GildedChestType.type;
    }

    @NotNull
    public UUID getInfoUUID() {
        return this.lootrInstance.getInfoUUID();
    }

    public String getInfoKey() {
        return this.lootrInstance.getInfoKey();
    }

    public boolean hasBeenOpened() {
        return this.lootrInstance.hasBeenOpened();
    }

    public boolean isPhysicallyOpen() {
        if (this.level != null && this.level.isClientSide()) {
            return this.posableState.getCurrentPose().equals("open");
        }
        return false;
    }

    public void unpackLootTable(@Nullable Player player) {
    }

    public int getPhysicalOpenerCount() {
        return this.openersCounter.getOpenerCount();
    }

    public static int getOpenCount(BlockGetter level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof GildedLootChestBlockEntity) {
            GildedLootChestBlockEntity chest = (GildedLootChestBlockEntity)be;
            return chest.openersCounter.getOpenerCount();
        }
        return 0;
    }

    @NotNull
    public BlockPos getInfoPos() {
        return this.getBlockPos();
    }

    @Nullable
    public Component getInfoDisplayName() {
        return this.getDefaultName();
    }

    @NotNull
    public ResourceKey<Level> getInfoDimension() {
        return this.level.dimension();
    }

    public int getInfoContainerSize() {
        return this.getContainerSize();
    }

    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory() {
        return null;
    }

    public boolean isInfoReferenceInventory() {
        return false;
    }

    @Nullable
    public ResourceKey<LootTable> getInfoLootTable() {
        return this.lootTable;
    }

    public long getInfoLootSeed() {
        return this.lootTableSeed;
    }

    private void signalOpenCount(Level level, BlockPos pos, BlockState state, int p155364, int p155365) {
        level.blockEvent(pos, this.getBlockState().getBlock(), 1, p155365);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        this.trySaveLootTable(compoundTag);
        this.lootrInstance.saveAdditional(compoundTag, provider, this.level != null && this.level.isClientSide());
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.tryLoadLootTable(compoundTag);
        this.lootrInstance.loadAdditional(compoundTag, provider);
    }

    public void saveToItem(ItemStack itemstack, HolderLookup.Provider provider) {
        this.lootrInstance.setSavingToItem(true);
        super.saveToItem(itemstack, provider);
        this.lootrInstance.setSavingToItem(false);
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public boolean triggerEvent(int i, int j) {
        if (i == 1) {
            boolean isNowOpen = j > 0;
            boolean wasOpen = this.posableState.getCurrentPose().equals("open");
            PosableModel model = this.posableState.getCurrentModel();
            if (model != null) {
                if (isNowOpen && !wasOpen) {
                    model.moveToPose((PosableState)this.posableState, model.getPose("open"));
                } else {
                    model.moveToPose((PosableState)this.posableState, model.getPose("closed"));
                }
            }
            return true;
        }
        return super.triggerEvent(i, j);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag result = super.getUpdateTag(provider);
        this.lootrInstance.fillUpdateTag(result, provider, this.level != null && this.level.isClientSide());
        return result;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
    }

    protected static void playSound(Level pLevel, BlockPos pPos, BlockState pState, SoundEvent pSound) {
        double d0 = (double)pPos.getX() + 0.5;
        double d1 = (double)pPos.getY() + 0.5;
        double d2 = (double)pPos.getZ() + 0.5;
        pLevel.playSound(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, pLevel.random.nextFloat() * 0.1f + 0.9f);
    }

    @AutoService(value={ILootrBlockEntityConverter.class})
    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<GildedLootChestBlockEntity> {
        public ILootrBlockEntity apply(GildedLootChestBlockEntity blockEntity) {
            return blockEntity;
        }

        public BlockEntityType<?> getBlockEntityType() {
            return type.get();
        }
    }
}

