/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootrmon.common.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootrmon.common.block.entity.GildedLootChestBlockEntity;
import org.jetbrains.annotations.Nullable;

public class GildedLootChestBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private static final MapCodec<GildedLootChestBlock> CODEC = GildedLootChestBlock.simpleCodec(GildedLootChestBlock::new);
    private static final VoxelShape SOUTH_OUTLINE = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)1.0, (double)0.9375), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape NORTH_OUTLINE = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0625, (double)1.0, (double)1.0, (double)0.75), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape WEST_OUTLINE = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape EAST_OUTLINE = Shapes.or((VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.0, (double)0.9375, (double)1.0, (double)1.0), (VoxelShape[])new VoxelShape[0]);
    public static Supplier<GildedLootChestBlock> type;

    public GildedLootChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return switch ((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> NORTH_OUTLINE;
            case Direction.SOUTH -> SOUTH_OUTLINE;
            case Direction.WEST -> WEST_OUTLINE;
            default -> EAST_OUTLINE;
        };
    }

    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    protected FluidState getFluidState(BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult trace) {
        if (level.isClientSide() || player.isSpectator() || !(player instanceof ServerPlayer)) {
            return InteractionResult.CONSUME;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.isShiftKeyDown()) {
            LootrAPI.handleProviderSneak((ILootrInfoProvider)ILootrInfoProvider.of((BlockPos)pos, (Level)level), (ServerPlayer)serverPlayer);
        } else {
            LootrAPI.handleProviderOpen((ILootrInfoProvider)ILootrInfoProvider.of((BlockPos)pos, (Level)level), (ServerPlayer)serverPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    protected void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        super.tick(blockState, serverLevel, blockPos, randomSource);
        BlockEntity blockentity = serverLevel.getBlockEntity(blockPos);
        if (blockentity instanceof GildedLootChestBlockEntity) {
            GildedLootChestBlockEntity chest = (GildedLootChestBlockEntity)blockentity;
            chest.recheckOpen();
        }
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        return LootrAPI.getDestroyProgress((BlockState)pState, (Player)pPlayer, (BlockGetter)pLevel, (BlockPos)pPos, (float)super.getDestroyProgress(pState, pPlayer, pLevel, pPos));
    }

    public int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return LootrAPI.getAnalogOutputSignal((BlockState)pBlockState, (Level)pLevel, (BlockPos)pPos, (int)0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return ILootrBlockEntity::ticker;
    }

    public void playerDestroy(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.playerDestroy(level, player, blockPos, blockState, blockEntity, itemStack);
        LootrAPI.playerDestroyed((Level)level, (Player)player, (BlockPos)blockPos, (BlockEntity)blockEntity);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new GildedLootChestBlockEntity(blockPos, blockState);
    }
}

