/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.recipes;

import com.necro.fireworkcapsules.common.components.FireworkCapsuleComponents;
import com.necro.fireworkcapsules.common.item.StickerItem;
import com.necro.fireworkcapsules.common.recipes.FireworkCapsuleRecipes;
import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StickerRecipe
extends CustomRecipe {
    private static final Ingredient TRAIL_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND});
    private static final Ingredient TWINKLE_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST});

    public StickerRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput recipeInput, Level level) {
        boolean sticker = false;
        boolean trail = false;
        boolean twinkle = false;
        int colors = 0;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack itemStack = recipeInput.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (itemStack.getItem() instanceof StickerItem) {
                if (sticker) {
                    return false;
                }
                sticker = true;
                continue;
            }
            if (TRAIL_INGREDIENT.test(itemStack)) {
                if (trail) {
                    return false;
                }
                trail = true;
                continue;
            }
            if (TWINKLE_INGREDIENT.test(itemStack)) {
                if (twinkle) {
                    return false;
                }
                twinkle = true;
                continue;
            }
            if (itemStack.getItem() instanceof DyeItem) {
                ++colors;
                continue;
            }
            return false;
        }
        return sticker && (trail || twinkle || colors > 0);
    }

    @NotNull
    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        ItemStack sticker = ItemStack.EMPTY;
        IntArrayList fadeColors = new IntArrayList();
        boolean hasTrail = false;
        boolean hasTwinkle = false;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack itemStack = recipeInput.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (itemStack.getItem() instanceof StickerItem) {
                sticker = itemStack;
                continue;
            }
            if (TRAIL_INGREDIENT.test(itemStack)) {
                hasTrail = true;
                continue;
            }
            if (TWINKLE_INGREDIENT.test(itemStack)) {
                hasTwinkle = true;
                continue;
            }
            Item item = itemStack.getItem();
            if (!(item instanceof DyeItem)) continue;
            DyeItem dye = (DyeItem)item;
            fadeColors.add(dye.getDyeColor().getFireworkColor());
        }
        ItemStack stack = sticker.copy();
        stack.setCount(1);
        StickerExplosion explosion = (StickerExplosion)stack.get((DataComponentType)FireworkCapsuleComponents.STICKER_EXPLOSION.value());
        assert (explosion != null);
        fadeColors.addAll(explosion.fadeColors());
        StickerExplosion newExplosion = new StickerExplosion(explosion.id(), explosion.colors(), (IntList)fadeColors, hasTrail || explosion.hasTrail(), hasTwinkle || explosion.hasTwinkle());
        stack.set((DataComponentType)FireworkCapsuleComponents.STICKER_EXPLOSION.value(), (Object)newExplosion);
        return stack;
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FireworkCapsuleRecipes.STICKER_RECIPE.value();
    }
}

