/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.recipes;

import com.necro.fireworkcapsules.common.components.FireworkCapsuleComponents;
import com.necro.fireworkcapsules.common.item.FireworkCapsuleItems;
import com.necro.fireworkcapsules.common.item.StickerItem;
import com.necro.fireworkcapsules.common.recipes.FireworkCapsuleRecipes;
import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import com.necro.fireworkcapsules.common.stickers.Stickers;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CapsuleRecipe
extends CustomRecipe {
    private static final Ingredient STAR_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{Items.FIREWORK_STAR});
    private static final Ingredient POKEBALL_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)FireworkCapsuleItems.BALL_CAPSULE.value()});

    public CapsuleRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput recipeInput, Level level) {
        int stickers = 0;
        int capsules = 0;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack itemStack = recipeInput.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (STAR_INGREDIENT.test(itemStack) || itemStack.getItem() instanceof StickerItem) {
                ++stickers;
                continue;
            }
            if (POKEBALL_INGREDIENT.test(itemStack)) {
                ++capsules;
                continue;
            }
            return false;
        }
        return stickers > 0 && capsules == 1;
    }

    @NotNull
    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        ArrayList<StickerExplosion> list = new ArrayList<StickerExplosion>();
        for (int i = 0; i < recipeInput.size(); ++i) {
            StickerExplosion stickerExplosion;
            ItemStack itemStack = recipeInput.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (STAR_INGREDIENT.test(itemStack)) {
                FireworkExplosion fireworkExplosion = (FireworkExplosion)itemStack.get(DataComponents.FIREWORK_EXPLOSION);
                if (fireworkExplosion == null) continue;
                list.add(StickerExplosion.fromFireworks(fireworkExplosion));
                continue;
            }
            if (!(itemStack.getItem() instanceof StickerItem) || (stickerExplosion = (StickerExplosion)itemStack.get((DataComponentType)FireworkCapsuleComponents.STICKER_EXPLOSION.value())) == null) continue;
            list.add(stickerExplosion);
        }
        ItemStack stack = this.getResultItem(provider);
        stack.set((DataComponentType)FireworkCapsuleComponents.STICKERS.value(), (Object)new Stickers(list));
        return stack;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return new ItemStack(FireworkCapsuleItems.BALL_CAPSULE);
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FireworkCapsuleRecipes.CAPSULE_RECIPE.value();
    }
}

