/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.particles.custom;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.necro.fireworkcapsules.common.stickers.StickerExplosion;
import com.necro.fireworkcapsules.common.util.CustomParticleFunction;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StickerParticle
extends SimpleAnimatedParticle {
    protected float rotateSpeed;
    protected boolean isStatic;
    protected boolean trail;
    protected boolean twinkle;
    protected final ParticleEngine engine;
    protected float fadeR;
    protected float fadeG;
    protected float fadeB;
    protected boolean hasFade;

    StickerParticle(ClientLevel clientLevel, double x, double y, double z, double xd, double yd, double zd, ParticleEngine particleEngine, SpriteSet spriteSet) {
        super(clientLevel, x, y, z, spriteSet, 0.0f);
        this.setSize(0.02f, 0.02f);
        this.lifetime = 10 + this.random.nextInt(30);
        this.rotateSpeed = 0.0f;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.engine = particleEngine;
        this.quadSize *= 0.75f;
        this.isStatic = false;
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        if (this.rotateSpeed != 0.0f) {
            this.oRoll = this.roll;
            this.roll += (float)Math.PI * this.rotateSpeed;
        }
        super.tick();
        if (this.trail && this.age < this.lifetime / 2 && (this.age + this.lifetime) % 2 == 0) {
            StickerParticle stickerParticle = (StickerParticle)this.createTrail();
            stickerParticle.setAlpha(0.99f);
            stickerParticle.setColor(this.rCol, this.gCol, this.bCol);
            stickerParticle.age = stickerParticle.lifetime / 2;
            stickerParticle.gravity = this.gravity;
            if (this.hasFade) {
                stickerParticle.hasFade = true;
                stickerParticle.fadeR = this.fadeR;
                stickerParticle.fadeG = this.fadeG;
                stickerParticle.fadeB = this.fadeB;
            }
            stickerParticle.twinkle = this.twinkle;
            this.engine.add((Particle)stickerParticle);
        }
    }

    protected Particle createTrail() {
        double xd = (this.random.nextDouble() - 0.5) * 0.1;
        double yd = (this.random.nextDouble() - 0.5) * 0.1;
        double zd = (this.random.nextDouble() - 0.5) * 0.1;
        return new StickerParticle(this.level, this.x, this.y, this.z, xd, yd, zd, this.engine, this.sprites);
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        if (!this.twinkle || this.age < this.lifetime / 3 || (this.age + this.lifetime) / 3 % 2 == 0) {
            super.render(vertexConsumer, camera, f);
        }
    }

    public void setSpriteFromAge(SpriteSet spriteSet) {
        if (!this.isStatic) {
            super.setSpriteFromAge(spriteSet);
        }
    }

    public void setRotateSpeed(double rotateSpeedMulti) {
        this.rotateSpeed = (this.random.nextFloat() - 0.5f) * 0.05f * (float)rotateSpeedMulti;
        this.rotateSpeed = this.rotateSpeed < 0.0f ? Math.min(this.rotateSpeed, -0.01f * (float)rotateSpeedMulti) : Math.max(this.rotateSpeed, 0.01f * (float)rotateSpeedMulti);
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        if (isStatic) {
            this.pickSprite(this.sprites);
        }
    }

    public void setTrail(boolean trail) {
        this.trail = trail;
    }

    public void setTwinkle(boolean twinkle) {
        this.twinkle = twinkle;
    }

    public static CustomParticleFunction getConsumer(ParticleOptions particle) {
        return StickerParticle.getConsumer(particle, 0.0);
    }

    public static CustomParticleFunction getConsumer(ParticleOptions particle, double rotateSpeedMulti) {
        return StickerParticle.getConsumer(particle, rotateSpeedMulti, 0.0f);
    }

    public static CustomParticleFunction getConsumer(ParticleOptions particle, float gravity) {
        return StickerParticle.getConsumer(particle, 0.0, gravity);
    }

    public static CustomParticleFunction getConsumer(ParticleOptions particle, double rotateSpeedMulti, float gravity) {
        return (clientLevel, x, y, z, rot, particleEngine, explosion, scale, scaleFactor) -> particleEngine.add((Particle)new Starter(particle, clientLevel, x, y, z, 0.0, 0.0, 0.0, gravity, particleEngine, explosion, scale, scaleFactor, rotateSpeedMulti));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Starter
    extends NoRenderParticle {
        protected final ParticleOptions particle;
        protected final ParticleEngine engine;
        protected final StickerExplosion explosion;
        protected final float gravity;
        protected final float scale;
        protected final double scaleFactor;
        protected final double rotateSpeedMulti;
        protected int life;

        public Starter(ParticleOptions particle, ClientLevel clientLevel, double x, double y, double z, double xd, double yd, double zd, float gravity, ParticleEngine particleEngine, StickerExplosion explosion, float scale, double scaleFactor, double rotateSpeedMulti) {
            super(clientLevel, x, y, z, xd, yd, zd);
            this.particle = particle;
            this.engine = particleEngine;
            this.explosion = explosion;
            this.gravity = gravity;
            this.scale = scale;
            this.scaleFactor = Math.max(scaleFactor, 1.0);
            this.rotateSpeedMulti = rotateSpeedMulti;
            this.life = 0;
        }

        public void tick() {
            int i = 0;
            while ((double)i < 4.0 / this.scaleFactor) {
                double xn = (this.random.nextDouble() - 0.5) * 1.5 * (double)this.scale;
                double yn = (this.random.nextDouble() - 0.5) * 1.5 * (double)this.scale;
                double zn = (this.random.nextDouble() - 0.5) * 1.5 * (double)this.scale;
                Vec3 nd = new Vec3(xn, yn, zn).normalize();
                Vec3 n2 = nd.scale((double)(this.scale / 3.0f));
                double x2 = this.x + xn + n2.x();
                double y2 = this.y + yn + n2.y();
                double z2 = this.z + zn + n2.z();
                double xd = nd.x() * 0.01;
                double yd = nd.y() * 0.01;
                double zd = nd.z() * 0.01;
                this.createParticle(x2, y2, z2, xd, yd, zd);
                ++i;
            }
            if (this.life++ > 4) {
                this.remove();
            }
        }

        public void createParticle(double x, double y, double z, double xd, double yd, double zd) {
            StickerParticle stickerParticle = (StickerParticle)this.engine.createParticle(this.particle, x, y, z, xd, yd, zd);
            if (stickerParticle == null) {
                return;
            }
            stickerParticle.setTrail(this.explosion.hasTrail());
            stickerParticle.setTwinkle(this.explosion.hasTwinkle());
            stickerParticle.setAlpha(0.99f);
            stickerParticle.scale((float)Math.sqrt(this.scale));
            stickerParticle.setRotateSpeed(this.rotateSpeedMulti);
            stickerParticle.gravity = this.gravity;
            if (!this.explosion.fadeColors().isEmpty()) {
                stickerParticle.setFadeColor((Integer)Util.getRandom((List)this.explosion.fadeColors(), (RandomSource)this.random));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VariedColoredStickerProvider
    extends ColoredStickerProvider {
        private final RandomSource random = RandomSource.create();

        public VariedColoredStickerProvider(SpriteSet spriteSet, int color) {
            super(spriteSet, color);
        }

        @Override
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            StickerParticle stickerParticle = (StickerParticle)super.createParticle(simpleParticleType, clientLevel, d, e, f, g, h, i);
            if (stickerParticle == null) {
                return null;
            }
            stickerParticle.setSprite(stickerParticle.sprites.get(this.random));
            stickerParticle.setStatic(true);
            return stickerParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VariedStickerProvider
    extends StickerProvider {
        private final RandomSource random = RandomSource.create();

        public VariedStickerProvider(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            StickerParticle stickerParticle = (StickerParticle)super.createParticle(simpleParticleType, clientLevel, d, e, f, g, h, i);
            if (stickerParticle == null) {
                return null;
            }
            stickerParticle.setSprite(stickerParticle.sprites.get(this.random));
            stickerParticle.setStatic(true);
            return stickerParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ColoredStickerProvider
    extends StickerProvider {
        private final int color;

        public ColoredStickerProvider(SpriteSet spriteSet, int color) {
            super(spriteSet);
            this.color = color;
        }

        @Override
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            StickerParticle stickerParticle = (StickerParticle)super.createParticle(simpleParticleType, clientLevel, d, e, f, g, h, i);
            if (stickerParticle == null) {
                return null;
            }
            stickerParticle.setColor(this.color);
            return stickerParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StickerProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public StickerProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            StickerParticle stickerParticle = new StickerParticle(clientLevel, d, e, f, g, h, i, Minecraft.getInstance().particleEngine, this.sprites);
            stickerParticle.setAlpha(0.99f);
            return stickerParticle;
        }
    }
}

