/*
 * Decompiled with CFR 0.152.
 */
package com.necro.fireworkcapsules.common.blocks;

import com.cobblemon.mod.common.CobblemonSounds;
import com.mojang.serialization.MapCodec;
import com.necro.fireworkcapsules.common.gui.CapsuleStationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CapsuleStationBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<CapsuleStationBlock> CODEC = CapsuleStationBlock.simpleCodec(CapsuleStationBlock::new);
    public static final Component CONTAINER_TITLE = Component.translatable((String)"container.fireworkcapsules.capsule_station");
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.6875, (double)0.9375), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0625, (double)0.6875, (double)0.125, (double)0.9375, (double)0.8125, (double)0.9375), Shapes.box((double)0.0625, (double)0.8125, (double)0.125, (double)0.1875, (double)0.9375, (double)0.9375), Shapes.box((double)0.1875, (double)0.8125, (double)0.8125, (double)0.8125, (double)0.9375, (double)0.9375), Shapes.box((double)0.8125, (double)0.8125, (double)0.125, (double)0.9375, (double)0.9375, (double)0.9375)});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.6875, (double)0.9375), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0625, (double)0.6875, (double)0.0625, (double)0.875, (double)0.8125, (double)0.9375), Shapes.box((double)0.0625, (double)0.8125, (double)0.0625, (double)0.875, (double)0.9375, (double)0.1875), Shapes.box((double)0.0625, (double)0.8125, (double)0.8125, (double)0.875, (double)0.9375, (double)0.9375), Shapes.box((double)0.0625, (double)0.8125, (double)0.1875, (double)0.1875, (double)0.9375, (double)0.8125)});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.6875, (double)0.9375), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0625, (double)0.6875, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.875), Shapes.box((double)0.0625, (double)0.8125, (double)0.0625, (double)0.1875, (double)0.9375, (double)0.875), Shapes.box((double)0.1875, (double)0.8125, (double)0.0625, (double)0.8125, (double)0.9375, (double)0.1875), Shapes.box((double)0.8125, (double)0.8125, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.875)});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.6875, (double)0.9375), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.125, (double)0.6875, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.9375), Shapes.box((double)0.125, (double)0.8125, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.1875), Shapes.box((double)0.125, (double)0.8125, (double)0.8125, (double)0.9375, (double)0.9375, (double)0.9375), Shapes.box((double)0.8125, (double)0.8125, (double)0.1875, (double)0.9375, (double)0.9375, (double)0.8125)});

    public CapsuleStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public MapCodec<? extends CapsuleStationBlock> codec() {
        return CODEC;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(blockState.getMenuProvider(level, blockPos));
        level.playSound(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), CobblemonSounds.PC_ON, SoundSource.NEUTRAL, 0.5f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_OPEN, blockPos);
        return InteractionResult.CONSUME;
    }

    protected MenuProvider getMenuProvider(BlockState blockState, Level level, BlockPos blockPos) {
        return new SimpleMenuProvider((i, inventory, player) -> new CapsuleStationMenu(i, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)blockPos)), CONTAINER_TITLE);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @NotNull
    protected VoxelShape getShape(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return switch ((Direction)blockState.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @NotNull
    protected VoxelShape getOcclusionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return super.getShape(blockState, blockGetter, blockPos, CollisionContext.empty());
    }
}

