/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.crafting.recipe;

import com.blakebr0.cucumber.init.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class ShapedTransferDamageRecipe
extends ShapedRecipe {
    private final ItemStack result;
    private final boolean transferComponents;

    public ShapedTransferDamageRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification, boolean transferComponents) {
        super(group, category, pattern, result, showNotification);
        this.result = result;
        this.transferComponents = transferComponents;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider lookup) {
        ItemStack damageable = ItemStack.EMPTY;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack slotStack = inventory.getItem(i);
            if (!slotStack.isDamageableItem()) continue;
            damageable = slotStack;
            break;
        }
        if (damageable.isEmpty()) {
            return super.assemble(inventory, lookup);
        }
        ItemStack result = this.getResultItem(lookup).copy();
        if (this.transferComponents) {
            result.applyComponents(damageable.getComponentsPatch());
        } else {
            result.setDamageValue(damageable.getDamageValue());
        }
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_SHAPED_TRANSFER_DAMAGE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedTransferDamageRecipe> {
        public static final MapCodec<ShapedTransferDamageRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(recipe -> recipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(ShapedRecipe::showNotification), (App)Codec.BOOL.optionalFieldOf("transfer_components", (Object)Boolean.FALSE).forGetter(recipe -> recipe.transferComponents)).apply((Applicative)builder, ShapedTransferDamageRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedTransferDamageRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapedTransferDamageRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedTransferDamageRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapedTransferDamageRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean showNotification = buffer.readBoolean();
            boolean transferComponents = buffer.readBoolean();
            return new ShapedTransferDamageRecipe(group, category, pattern, result, showNotification, transferComponents);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ShapedTransferDamageRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.showNotification());
            buffer.writeBoolean(recipe.transferComponents);
        }
    }
}

