/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.client.screen.widget;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.util.Formatting;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class FuelWidget
extends AbstractWidget {
    private static final ResourceLocation WIDGETS_TEXTURE = Cucumber.resource("textures/gui/widgets.png");
    private final IntSupplier fuelValue;
    private final IntSupplier fuelLeft;

    public FuelWidget(int x, int y, IntSupplier fuelValue, IntSupplier fuelLeft) {
        super(x, y, 14, 14, (Component)Component.literal((String)"Fuel"));
        this.fuelValue = fuelValue;
        this.fuelLeft = fuelLeft;
        this.active = false;
    }

    protected void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        int offset = this.getBurnLeftScaled();
        gfx.blit(WIDGETS_TEXTURE, this.getX(), this.getY(), 30, 0, this.width, this.height);
        gfx.blit(WIDGETS_TEXTURE, this.getX(), this.getY() + this.height - offset, 44, this.height - offset, this.width, offset + 1);
        if (mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height) {
            Font font = Minecraft.getInstance().font;
            MutableComponent text = Formatting.energy(this.fuelLeft.getAsInt());
            gfx.renderTooltip(font, (Component)text, mouseX, mouseY);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }

    private int getBurnLeftScaled() {
        int i = this.fuelLeft.getAsInt();
        int j = this.fuelValue.getAsInt();
        return (int)(j != 0 && i != 0 ? (long)i * (long)this.height / (long)j : 0L);
    }
}

