/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.block;

import com.blakebr0.cucumber.block.BaseBlock;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BaseOreBlock
extends BaseBlock {
    private final IntProvider xpRange;

    public BaseOreBlock(Function<BlockBehaviour.Properties, BlockBehaviour.Properties> properties, int minExp, int maxExp) {
        super(properties.compose(BlockBehaviour.Properties::requiresCorrectToolForDrops));
        this.xpRange = UniformInt.of((int)minExp, (int)maxExp);
    }

    public BaseOreBlock(SoundType sound, float hardness, float resistance, int minExp, int maxExp) {
        this((BlockBehaviour.Properties p) -> p.sound(sound).strength(hardness, resistance), minExp, maxExp);
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, BlockEntity blockEntity, Entity breaker, ItemStack tool) {
        boolean hasSilkTouch = ((ItemEnchantments)tool.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).getLevel(level.registryAccess().holderOrThrow(Enchantments.SILK_TOUCH)) > 0;
        return hasSilkTouch ? 0 : this.xpRange.sample(level.getRandom());
    }
}

