/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.mixin;

import io.wispforest.accessories.DataLoaderBase;
import io.wispforest.accessories_compat.api.ModCompatibilityModule;
import io.wispforest.accessories_compat.api.ReloadListenerRegisterCallback;
import io.wispforest.accessories_compat.utils.ModifiableIdentifiableResourceReloadListener;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={DataLoaderBase.class}, remap=false)
public abstract class DataLoaderBaseMixin {
    @Shadow(remap=false)
    protected abstract Optional<PreparableReloadListener> getIdentifiedSlotLoader();

    @Shadow(remap=false)
    protected abstract Optional<PreparableReloadListener> getIdentifiedEntitySlotLoader();

    @Inject(method={"registerListeners"}, at={@At(value="HEAD")}, cancellable=true)
    private void adjustDependenciesAndAddListeners(CallbackInfo ci) {
        final ResourceManagerHelper manager = ResourceManagerHelper.get((PackType)PackType.SERVER_DATA);
        final IdentifiableResourceReloadListener slotLoader = (IdentifiableResourceReloadListener)this.getIdentifiedSlotLoader().orElseThrow(() -> new IllegalStateException("Unable to get the required SlotLoader listener for TCLayer to add as dependency!"));
        final IdentifiableResourceReloadListener entitySlotLoader = (IdentifiableResourceReloadListener)this.getIdentifiedEntitySlotLoader().orElseThrow(() -> new IllegalStateException("Unable to get the required EntitySlotLoader listener for TCLayer to add as dependency!"));
        ReloadListenerRegisterCallback callback = new ReloadListenerRegisterCallback(){

            @Override
            public void registerSlotLoader(PreparableReloadListener listener, ResourceLocation id) {
                IdentifiableResourceReloadListener castedListener;
                Object validListener = listener instanceof IdentifiableResourceReloadListener ? (castedListener = (IdentifiableResourceReloadListener)listener) : new ModifiableIdentifiableResourceReloadListener(id, listener, new ResourceLocation[0]);
                manager.registerReloadListener(validListener);
                slotLoader.getFabricDependencies().add(id);
            }

            @Override
            public void registerEntitySlotLoader(PreparableReloadListener listener, ResourceLocation id) {
                IdentifiableResourceReloadListener castedListener;
                Object validListener = listener instanceof IdentifiableResourceReloadListener ? (castedListener = (IdentifiableResourceReloadListener)listener) : new ModifiableIdentifiableResourceReloadListener(id, listener, new ResourceLocation[0]);
                manager.registerReloadListener(validListener);
                entitySlotLoader.getFabricDependencies().add(id);
            }
        };
        for (ModCompatibilityModule value : ModCompatibilityModule.getModules().values()) {
            value.registerDataLoaders(callback);
        }
        DataLoaderBase.LOGGER.info("Registered Trinkets Reloaded Listeners");
        ci.cancel();
    }
}

