/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.wrapper;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.LootingAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories_compat.curios.wrapper.CuriosConversionUtils;
import java.util.List;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CurioFromAccessory
implements ICurioItem {
    private final Accessory accessory;

    public CurioFromAccessory(Accessory accessory) {
        this.accessory = accessory;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        this.accessory.tick(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        this.accessory.onEquip(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        this.accessory.onUnequip(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return this.accessory.canEquip(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return this.accessory.canUnequip(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        SlotReference ref = CuriosConversionUtils.convertToA(slotContext);
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(ref);
        this.accessory.getDynamicModifiers(stack, ref, builder);
        return builder.getAttributeModifiers(false);
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        this.accessory.onEquipFromUse(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    @NotNull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        SoundEventData data = this.accessory.getEquipSound(stack, CuriosConversionUtils.convertToA(slotContext));
        return data == null ? super.getEquipSound(slotContext, stack) : new ICurio.SoundInfo((SoundEvent)data.event().value(), data.volume(), data.pitch());
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return this.accessory.canEquipFromUse(stack);
    }

    public void curioBreak(SlotContext slotContext, ItemStack stack) {
        this.accessory.onBreak(stack, CuriosConversionUtils.convertToA(slotContext));
    }

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, boolean recentlyHit, ItemStack stack) {
        return CuriosConversionUtils.dropRuleConvertToC(this.accessory.getDropRule(stack, CuriosConversionUtils.convertToA(slotContext), source));
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        try {
            this.accessory.getAttributesTooltip(stack, null, tooltips, context, (TooltipFlag)TooltipFlag.NORMAL);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return tooltips;
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack stack) {
        Accessory accessory = this.accessory;
        if (accessory instanceof FortuneAdjustment) {
            FortuneAdjustment adjustment = (FortuneAdjustment)accessory;
            return adjustment.getFortuneAdjustment(stack, CuriosConversionUtils.convertToA(slotContext), lootContext, 0);
        }
        return super.getFortuneLevel(slotContext, lootContext, stack);
    }

    public int getLootingLevel(SlotContext slotContext, @Nullable LootContext lootContext, ItemStack stack) {
        Object object;
        if (lootContext != null && (object = lootContext.getParam(LootContextParams.ATTACKING_ENTITY)) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)object;
            DamageSource damageSource = (DamageSource)lootContext.getParamOrNull(LootContextParams.DAMAGE_SOURCE);
            if (damageSource != null) {
                Accessory accessory = this.accessory;
                if (accessory instanceof LootingAdjustment) {
                    LootingAdjustment lootingAdjustment = (LootingAdjustment)accessory;
                    return lootingAdjustment.getLootingAdjustment(stack, CuriosConversionUtils.convertToA(slotContext), target, damageSource, 0);
                }
                accessory = this.accessory;
                if (accessory instanceof io.wispforest.accessories.api.events.extra.v2.LootingAdjustment) {
                    io.wispforest.accessories.api.events.extra.v2.LootingAdjustment lootingAdjustment = (io.wispforest.accessories.api.events.extra.v2.LootingAdjustment)accessory;
                    return lootingAdjustment.getLootingAdjustment(stack, CuriosConversionUtils.convertToA(slotContext), target, lootContext, damageSource, 0);
                }
            }
        }
        return super.getLootingLevel(slotContext, lootContext, stack);
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        TriState state = TriState.DEFAULT;
        Accessory accessory = this.accessory;
        if (accessory instanceof PiglinNeutralInducer) {
            PiglinNeutralInducer inducer = (PiglinNeutralInducer)accessory;
            state = inducer.makePiglinsNeutral(stack, CuriosConversionUtils.convertToA(slotContext));
        }
        return state.orElse(super.makesPiglinsNeutral(slotContext, stack));
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        TriState state = TriState.DEFAULT;
        Accessory accessory = this.accessory;
        if (accessory instanceof AllowWalkingOnSnow) {
            AllowWalkingOnSnow predicate = (AllowWalkingOnSnow)accessory;
            state = predicate.allowWalkingOnSnow(stack, CuriosConversionUtils.convertToA(slotContext));
        }
        return state.orElse(super.canWalkOnPowderedSnow(slotContext, stack));
    }

    public boolean isEnderMask(SlotContext slotContext, EnderMan enderMan, ItemStack stack) {
        TriState state = TriState.DEFAULT;
        Accessory accessory = this.accessory;
        if (accessory instanceof EndermanMasked) {
            EndermanMasked predicate = (EndermanMasked)accessory;
            state = predicate.isEndermanMasked(enderMan, stack, CuriosConversionUtils.convertToA(slotContext));
        }
        return state.orElse(super.isEnderMask(slotContext, enderMan, stack));
    }
}

