/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.curios.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories_compat.curios.pond.CurioInventoryCapabilityExtension;
import io.wispforest.accessories_compat.curios.pond.CurioInventoryExtension;
import io.wispforest.accessories_compat.curios.wrapper.AccessoriesBasedStackHandler;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.capability.CurioInventory;
import top.theillusivec4.curios.common.capability.CurioInventoryCapability;

@Mixin(value={CurioInventoryCapability.class})
public abstract class CurioInventoryCapabilityMixin
implements CurioInventoryCapabilityExtension {
    @Shadow
    @Final
    private CurioInventory curioInventory;
    @Shadow
    @Final
    private LivingEntity livingEntity;
    @Unique
    private AccessoriesCapabilityImpl capability = null;

    @Shadow
    public abstract void reset();

    @Override
    public AccessoriesCapabilityImpl capability() {
        return this.capability;
    }

    @ModifyExpressionValue(method={"<init>(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="FIELD", target="Ltop/theillusivec4/curios/common/capability/CurioInventory;markDeserialized:Z")})
    private boolean initCapabilityFromEntity(boolean original, @Local(argsOnly=true) LivingEntity livingEntity) {
        if (CurioInventoryCapabilityExtension.CURRENTLY_CONVERTING.contains(livingEntity)) {
            return false;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)livingEntity);
        if (capability == null) {
            throw new NullPointerException("Unable to create the CurioInventoryCapability due to the given AccessoriesCapability being null for the given entity! [Entity: " + String.valueOf(livingEntity) + "]");
        }
        this.capability = (AccessoriesCapabilityImpl)capability;
        return true;
    }

    @Override
    public void capability(AccessoriesCapabilityImpl capability) {
        this.capability = capability;
        this.reset();
    }

    @Overwrite
    public void loseInvalidStack(ItemStack stack) {
        ((CurioInventoryExtension)this.curioInventory).getInvalidStacks().add(stack);
    }

    @Overwrite(remap=false)
    public void handleInvalidStacks() {
        if (this.livingEntity != null && !((CurioInventoryExtension)this.curioInventory).getInvalidStacks().isEmpty()) {
            LivingEntity livingEntity = this.livingEntity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ((CurioInventoryExtension)this.curioInventory).getInvalidStacks().forEach(drop -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop));
            } else {
                ((CurioInventoryExtension)this.curioInventory).getInvalidStacks().forEach(drop -> {
                    ItemEntity ent = this.livingEntity.spawnAtLocation(drop, 1.0f);
                    RandomSource rand = this.livingEntity.getRandom();
                    if (ent != null) {
                        ent.setDeltaMovement(ent.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                    }
                });
            }
            ((CurioInventoryExtension)this.curioInventory).getInvalidStacks().clear();
        }
    }

    @WrapOperation(method={"getCurios"}, at={@At(value="INVOKE", target="Ltop/theillusivec4/curios/common/capability/CurioInventory;asMap()Ljava/util/Map;")}, remap=false)
    private Map<String, ICurioStacksHandler> adjustMapGrabToMethod(CurioInventory instance, Operation<Map<String, ICurioStacksHandler>> original) {
        return ((CurioInventoryExtension)instance).getCuriosSlotView(true);
    }

    @Overwrite(remap=false)
    public Set<ICurioStacksHandler> getUpdatingInventories() {
        return ((AccessoriesCapabilityImpl)this.capability.getHolder()).getUpdatingInventories().keySet().stream().map(container -> new AccessoriesBasedStackHandler((AccessoriesContainer)container)).collect(Collectors.toUnmodifiableSet());
    }
}

