/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories_compat.api;

import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories_compat.api.EntityBindingModifier;
import io.wispforest.accessories_compat.api.ReloadListenerRegisterCallback;
import io.wispforest.accessories_compat.api.tags.SlotTypesModifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SequencedSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ModCompatibilityModule {
    public static final Map<String, ModCompatibilityModule> MODULES = new HashMap<String, ModCompatibilityModule>();
    private final String modid;

    protected ModCompatibilityModule(String modid) {
        this.modid = modid;
        if (MODULES.containsKey(modid)) {
            throw new IllegalStateException("Unable to add CompatibilityModule as such id has been registered already! Id: " + modid);
        }
        MODULES.put(modid, this);
        this.init();
    }

    public static Map<String, ModCompatibilityModule> getModules() {
        return Collections.unmodifiableMap(MODULES);
    }

    public final String modid() {
        return this.modid;
    }

    public final ResourceLocation getAllItemTag() {
        return ResourceLocation.fromNamespaceAndPath((String)"accessories_compat_layer", (String)("all_" + this.modid() + "_items"));
    }

    public void init() {
    }

    public abstract void registerDataLoaders(ReloadListenerRegisterCallback var1);

    public abstract void addEntityBindings(EntityBindingModifier var1);

    public abstract void addSlotTypes(SlotTypesModifier var1);

    public abstract SequencedSet<ResourceLocation> toAccessoriesTag(ResourceLocation var1);

    public abstract SequencedSet<ResourceLocation> fromAccessoriesTag(ResourceLocation var1);

    @Nullable
    public ResourceLocation toAccessoriesTagFirst(ResourceLocation moduleSlotTag) {
        SequencedSet<ResourceLocation> tags = this.toAccessoriesTag(moduleSlotTag);
        if (tags.isEmpty()) {
            return null;
        }
        return (ResourceLocation)this.toAccessoriesTag(moduleSlotTag).getFirst();
    }

    public ResourceLocation fromAccessoriesTagFirst(ResourceLocation accessoriesSlotTag) {
        return (ResourceLocation)this.fromAccessoriesTag(accessoriesSlotTag).getFirst();
    }

    public abstract void getAttributes(ItemStack var1, @Nullable LivingEntity var2, String var3, int var4, AccessoryAttributeBuilder var5);

    public abstract boolean skipOnEquipCheck(ItemStack var1, Accessory var2);

    public abstract boolean skipDefaultRenderer(Item var1);
}

